/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.store.StoreStats;
import org.opensearch.indices.replication.common.ReplicationTimer;

@PublicApi(since="1.0.0")
public final class ReplicationLuceneIndex
extends ReplicationTimer
implements ToXContentFragment,
Writeable {
    private final FilesDetails filesDetails;
    public static final long UNKNOWN = -1L;
    private long sourceThrottlingInNanos = -1L;
    private long targetThrottleTimeInNanos = -1L;

    public ReplicationLuceneIndex() {
        this(new FilesDetails());
    }

    public ReplicationLuceneIndex(FilesDetails filesDetails) {
        this.filesDetails = filesDetails;
    }

    public ReplicationLuceneIndex(StreamInput in) throws IOException {
        super(in);
        this.filesDetails = new FilesDetails(in);
        this.sourceThrottlingInNanos = in.readLong();
        this.targetThrottleTimeInNanos = in.readLong();
    }

    @Override
    public synchronized void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.filesDetails.writeTo(out);
        out.writeLong(this.sourceThrottlingInNanos);
        out.writeLong(this.targetThrottleTimeInNanos);
    }

    public synchronized List<FileMetadata> fileDetails() {
        return Collections.unmodifiableList(new ArrayList<FileMetadata>(this.filesDetails.values()));
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.filesDetails.clear();
        this.sourceThrottlingInNanos = -1L;
        this.targetThrottleTimeInNanos = -1L;
    }

    public synchronized void addFileDetail(String name, long length, boolean reused) {
        this.filesDetails.addFileDetails(name, length, reused);
    }

    public synchronized void setFileDetailsComplete() {
        this.filesDetails.setComplete();
    }

    public synchronized void addRecoveredBytesToFile(String name, long bytes) {
        this.filesDetails.addRecoveredBytesToFile(name, bytes);
    }

    public synchronized void addSourceThrottling(long timeInNanos) {
        this.sourceThrottlingInNanos = this.sourceThrottlingInNanos == -1L ? timeInNanos : (this.sourceThrottlingInNanos += timeInNanos);
    }

    public synchronized void addTargetThrottling(long timeInNanos) {
        this.targetThrottleTimeInNanos = this.targetThrottleTimeInNanos == -1L ? timeInNanos : (this.targetThrottleTimeInNanos += timeInNanos);
    }

    public synchronized TimeValue sourceThrottling() {
        return TimeValue.timeValueNanos((long)this.sourceThrottlingInNanos);
    }

    public synchronized TimeValue targetThrottling() {
        return TimeValue.timeValueNanos((long)this.targetThrottleTimeInNanos);
    }

    public synchronized int totalFileCount() {
        return this.filesDetails.size();
    }

    public synchronized int totalRecoverFiles() {
        int total = 0;
        for (FileMetadata file : this.filesDetails.values()) {
            if (file.reused()) continue;
            ++total;
        }
        return total;
    }

    public synchronized int recoveredFileCount() {
        int count = 0;
        for (FileMetadata file : this.filesDetails.values()) {
            if (!file.fullyRecovered()) continue;
            ++count;
        }
        return count;
    }

    public synchronized float recoveredFilesPercent() {
        int total = 0;
        int recovered = 0;
        for (FileMetadata file : this.filesDetails.values()) {
            if (file.reused()) continue;
            ++total;
            if (!file.fullyRecovered()) continue;
            ++recovered;
        }
        if (total == 0 && this.filesDetails.size() == 0) {
            return 0.0f;
        }
        if (total == recovered) {
            return 100.0f;
        }
        float result = 100.0f * ((float)recovered / (float)total);
        return result;
    }

    public synchronized long totalBytes() {
        long total = 0L;
        for (FileMetadata file : this.filesDetails.values()) {
            total += file.length();
        }
        return total;
    }

    public synchronized long recoveredBytes() {
        long recovered = 0L;
        for (FileMetadata file : this.filesDetails.values()) {
            recovered += file.recovered();
        }
        return recovered;
    }

    public synchronized long totalRecoverBytes() {
        long total = 0L;
        for (FileMetadata file : this.filesDetails.values()) {
            if (file.reused()) continue;
            total += file.length();
        }
        return total;
    }

    public synchronized long bytesStillToRecover() {
        if (!this.filesDetails.isComplete()) {
            return -1L;
        }
        long total = 0L;
        for (FileMetadata file : this.filesDetails.values()) {
            if (file.reused()) continue;
            total += file.length() - file.recovered();
        }
        return total;
    }

    public synchronized float recoveredBytesPercent() {
        long total = 0L;
        long recovered = 0L;
        for (FileMetadata file : this.filesDetails.values()) {
            if (file.reused()) continue;
            total += file.length();
            recovered += file.recovered();
        }
        if (total == 0L && this.filesDetails.size() == 0) {
            return 0.0f;
        }
        if (total == recovered) {
            return 100.0f;
        }
        return 100.0f * (float)recovered / (float)total;
    }

    public synchronized int reusedFileCount() {
        int reused = 0;
        for (FileMetadata file : this.filesDetails.values()) {
            if (!file.reused()) continue;
            ++reused;
        }
        return reused;
    }

    public synchronized long reusedBytes() {
        long reused = 0L;
        for (FileMetadata file : this.filesDetails.values()) {
            if (!file.reused()) continue;
            reused += file.length();
        }
        return reused;
    }

    public synchronized XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("size");
        builder.humanReadableField("total_in_bytes", "total", (Object)new ByteSizeValue(this.totalBytes()));
        builder.humanReadableField("reused_in_bytes", "reused", (Object)new ByteSizeValue(this.reusedBytes()));
        builder.humanReadableField("recovered_in_bytes", "recovered", (Object)new ByteSizeValue(this.recoveredBytes()));
        builder.field("percent", String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(this.recoveredBytesPercent())));
        builder.endObject();
        builder.startObject("files");
        builder.field("total", this.totalFileCount());
        builder.field("reused", this.reusedFileCount());
        builder.field("recovered", this.recoveredFileCount());
        builder.field("percent", String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(this.recoveredFilesPercent())));
        this.filesDetails.toXContent(builder, params);
        builder.endObject();
        builder.humanReadableField("total_time_in_millis", "total_time", (Object)new TimeValue(this.time()));
        builder.humanReadableField("source_throttle_time_in_millis", "source_throttle_time", (Object)this.sourceThrottling());
        builder.humanReadableField("target_throttle_time_in_millis", "target_throttle_time", (Object)this.targetThrottling());
        return builder;
    }

    public synchronized String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.toString();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    public synchronized FileMetadata getFileDetails(String dest) {
        return this.filesDetails.get(dest);
    }

    static final class Fields {
        static final String TOTAL_TIME = "total_time";
        static final String TOTAL_TIME_IN_MILLIS = "total_time_in_millis";
        static final String NAME = "name";
        static final String RECOVERED = "recovered";
        static final String RECOVERED_IN_BYTES = "recovered_in_bytes";
        static final String LENGTH = "length";
        static final String LENGTH_IN_BYTES = "length_in_bytes";
        static final String FILES = "files";
        static final String TOTAL = "total";
        static final String TOTAL_IN_BYTES = "total_in_bytes";
        static final String REUSED = "reused";
        static final String REUSED_IN_BYTES = "reused_in_bytes";
        static final String PERCENT = "percent";
        static final String DETAILS = "details";
        static final String SIZE = "size";
        static final String SOURCE_THROTTLE_TIME = "source_throttle_time";
        static final String SOURCE_THROTTLE_TIME_IN_MILLIS = "source_throttle_time_in_millis";
        static final String TARGET_THROTTLE_TIME = "target_throttle_time";
        static final String TARGET_THROTTLE_TIME_IN_MILLIS = "target_throttle_time_in_millis";

        Fields() {
        }
    }

    @PublicApi(since="1.0.0")
    public static final class FileMetadata
    implements ToXContentObject,
    Writeable {
        private String name;
        private long length;
        private long recovered;
        private boolean reused;

        public FileMetadata(String name, long length, boolean reused) {
            assert (name != null);
            this.name = name;
            this.length = length;
            this.reused = reused;
        }

        public FileMetadata(StreamInput in) throws IOException {
            this.name = in.readString();
            this.length = in.readVLong();
            this.recovered = in.readVLong();
            this.reused = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeVLong(this.length);
            out.writeVLong(this.recovered);
            out.writeBoolean(this.reused);
        }

        public void addRecoveredBytes(long bytes) {
            assert (!this.reused) : "file is marked as reused, can't update recovered bytes";
            assert (bytes >= 0L) : "can't recovered negative bytes. got [" + bytes + "]";
            this.recovered += bytes;
        }

        public String name() {
            return this.name;
        }

        public long length() {
            return this.length;
        }

        public long recovered() {
            return this.recovered;
        }

        public boolean reused() {
            return this.reused;
        }

        public boolean fullyRecovered() {
            return !this.reused && this.length == this.recovered;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.name);
            builder.humanReadableField("length_in_bytes", "length", (Object)new ByteSizeValue(this.length));
            builder.field("reused", this.reused);
            builder.humanReadableField("recovered_in_bytes", "recovered", (Object)new ByteSizeValue(this.recovered));
            builder.endObject();
            return builder;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileMetadata) {
                FileMetadata other = (FileMetadata)obj;
                return this.name.equals(other.name) && this.length == other.length() && this.reused == other.reused() && this.recovered == other.recovered();
            }
            return false;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + Long.hashCode(this.length);
            result = 31 * result + Long.hashCode(this.recovered);
            result = 31 * result + (this.reused ? 1 : 0);
            return result;
        }

        public String toString() {
            return "file (name [" + this.name + "], reused [" + this.reused + "], length [" + this.length + "], recovered [" + this.recovered + "])";
        }
    }

    private static final class FilesDetails
    implements ToXContentFragment,
    Writeable {
        protected final Map<String, FileMetadata> fileMetadataMap = new HashMap<String, FileMetadata>();
        protected boolean complete;

        public FilesDetails() {
        }

        FilesDetails(StreamInput in) throws IOException {
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                FileMetadata file = new FileMetadata(in);
                this.fileMetadataMap.put(file.name, file);
            }
            this.complete = in.getVersion().onOrAfter(StoreStats.RESERVED_BYTES_VERSION) ? in.readBoolean() : !this.fileMetadataMap.isEmpty();
        }

        public void writeTo(StreamOutput out) throws IOException {
            FileMetadata[] files = this.values().toArray(new FileMetadata[0]);
            out.writeVInt(files.length);
            for (FileMetadata file : files) {
                file.writeTo(out);
            }
            if (out.getVersion().onOrAfter(StoreStats.RESERVED_BYTES_VERSION)) {
                out.writeBoolean(this.complete);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (params.paramAsBoolean("detailed", false)) {
                builder.startArray("details");
                for (FileMetadata file : this.values()) {
                    file.toXContent(builder, params);
                }
                builder.endArray();
            }
            return builder;
        }

        public void addFileDetails(String name, long length, boolean reused) {
            assert (!this.complete) : "addFileDetail for [" + name + "] when file details are already complete";
            FileMetadata existing = this.fileMetadataMap.put(name, new FileMetadata(name, length, reused));
            assert (existing == null) : "file [" + name + "] is already reported";
        }

        public void addRecoveredBytesToFile(String name, long bytes) {
            FileMetadata file = this.fileMetadataMap.get(name);
            assert (file != null) : "file [" + name + "] hasn't been reported";
            file.addRecoveredBytes(bytes);
        }

        public FileMetadata get(String name) {
            return this.fileMetadataMap.get(name);
        }

        public void setComplete() {
            this.complete = true;
        }

        public int size() {
            return this.fileMetadataMap.size();
        }

        public boolean isEmpty() {
            return this.fileMetadataMap.isEmpty();
        }

        public void clear() {
            this.fileMetadataMap.clear();
            this.complete = false;
        }

        public Collection<FileMetadata> values() {
            return this.fileMetadataMap.values();
        }

        public boolean isComplete() {
            return this.complete;
        }
    }
}

