/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.CorruptIndexException;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchCorruptionException;
import org.opensearch.action.support.ChannelActionListener;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.CancellableThreads;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardState;
import org.opensearch.index.store.Store;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.recovery.FileChunkRequest;
import org.opensearch.indices.recovery.ForceSyncRequest;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.indices.recovery.RetryableTransportClient;
import org.opensearch.indices.replication.SegmentReplicationSourceFactory;
import org.opensearch.indices.replication.SegmentReplicationState;
import org.opensearch.indices.replication.SegmentReplicationTarget;
import org.opensearch.indices.replication.UpdateVisibleCheckpointRequest;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.replication.common.ReplicationCollection;
import org.opensearch.indices.replication.common.ReplicationFailedException;
import org.opensearch.indices.replication.common.ReplicationListener;
import org.opensearch.indices.replication.common.ReplicationState;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportService;

public class SegmentReplicationTargetService
extends AbstractLifecycleComponent
implements ClusterStateListener,
IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SegmentReplicationTargetService.class);
    private final ThreadPool threadPool;
    private final RecoverySettings recoverySettings;
    private final ReplicationCollection<SegmentReplicationTarget> onGoingReplications;
    private final Map<ShardId, SegmentReplicationState> completedReplications = ConcurrentCollections.newConcurrentMap();
    private final SegmentReplicationSourceFactory sourceFactory;
    protected final Map<ShardId, ReplicationCheckpoint> latestReceivedCheckpoint = ConcurrentCollections.newConcurrentMap();
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final TransportService transportService;

    public ReplicationCollection.ReplicationRef<SegmentReplicationTarget> get(long replicationId) {
        return this.onGoingReplications.get(replicationId);
    }

    public SegmentReplicationTargetService(ThreadPool threadPool, RecoverySettings recoverySettings, TransportService transportService, SegmentReplicationSourceFactory sourceFactory, IndicesService indicesService, ClusterService clusterService) {
        this(threadPool, recoverySettings, transportService, sourceFactory, indicesService, clusterService, new ReplicationCollection<SegmentReplicationTarget>(logger, threadPool));
    }

    public SegmentReplicationTargetService(ThreadPool threadPool, RecoverySettings recoverySettings, TransportService transportService, SegmentReplicationSourceFactory sourceFactory, IndicesService indicesService, ClusterService clusterService, ReplicationCollection<SegmentReplicationTarget> ongoingSegmentReplications) {
        this.threadPool = threadPool;
        this.recoverySettings = recoverySettings;
        this.onGoingReplications = ongoingSegmentReplications;
        this.sourceFactory = sourceFactory;
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.transportService = transportService;
        transportService.registerRequestHandler("internal:index/shard/replication/file_chunk", "generic", FileChunkRequest::new, new FileChunkTransportRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/replication/segments_sync", "generic", ForceSyncRequest::new, new ForceSyncTransportRequestHandler());
    }

    protected void doStart() {
        if (DiscoveryNode.isDataNode(this.clusterService.getSettings())) {
            this.clusterService.addListener(this);
        }
    }

    protected void doStop() {
        if (DiscoveryNode.isDataNode(this.clusterService.getSettings())) {
            this.clusterService.removeListener(this);
        }
    }

    protected void doClose() throws IOException {
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.routingTableChanged()) {
            for (IndexService indexService : this.indicesService) {
                if (!indexService.getIndexSettings().isSegRepEnabled() || !event.indexRoutingTableChanged(indexService.index().getName())) continue;
                for (IndexShard shard : indexService) {
                    String currentNode;
                    String previousNode;
                    if (shard.routingEntry().primary() || (previousNode = event.previousState().routingTable().shardRoutingTable(shard.shardId()).primaryShard().currentNodeId()).equals(currentNode = event.state().routingTable().shardRoutingTable(shard.shardId()).primaryShard().currentNodeId())) continue;
                    this.processLatestReceivedCheckpoint(shard, Thread.currentThread());
                }
            }
        }
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        if (indexShard != null && indexShard.indexSettings().isSegRepEnabled()) {
            this.onGoingReplications.requestCancel(indexShard.shardId(), "Shard closing");
            this.latestReceivedCheckpoint.remove(shardId);
        }
    }

    @Override
    public void afterIndexShardStarted(IndexShard indexShard) {
        if (indexShard.indexSettings().isSegRepEnabled() && !indexShard.routingEntry().primary()) {
            this.processLatestReceivedCheckpoint(indexShard, Thread.currentThread());
        }
    }

    @Override
    public void shardRoutingChanged(IndexShard indexShard, @Nullable ShardRouting oldRouting, ShardRouting newRouting) {
        if (oldRouting != null && indexShard.indexSettings().isSegRepEnabled() && !oldRouting.primary() && newRouting.primary()) {
            this.onGoingReplications.requestCancel(indexShard.shardId(), "Shard has been promoted to primary");
            this.latestReceivedCheckpoint.remove(indexShard.shardId());
        }
    }

    @Nullable
    public SegmentReplicationState getOngoingEventSegmentReplicationState(ShardId shardId) {
        return Optional.ofNullable(this.onGoingReplications.getOngoingReplicationTarget(shardId)).map(SegmentReplicationTarget::state).orElse(null);
    }

    @Nullable
    public SegmentReplicationState getlatestCompletedEventSegmentReplicationState(ShardId shardId) {
        return this.completedReplications.get(shardId);
    }

    @Nullable
    public SegmentReplicationState getSegmentReplicationState(ShardId shardId) {
        return Optional.ofNullable(this.getOngoingEventSegmentReplicationState(shardId)).orElseGet(() -> this.getlatestCompletedEventSegmentReplicationState(shardId));
    }

    public synchronized void onNewCheckpoint(ReplicationCheckpoint receivedCheckpoint, final IndexShard replicaShard) {
        logger.debug(() -> new ParameterizedMessage("Replica received new replication checkpoint from primary [{}]", (Object)receivedCheckpoint));
        if (replicaShard.state().equals((Object)IndexShardState.CLOSED)) {
            logger.trace(() -> "Ignoring checkpoint, Shard is closed");
            return;
        }
        this.updateLatestReceivedCheckpoint(receivedCheckpoint, replicaShard);
        if (replicaShard.state().equals((Object)IndexShardState.STARTED)) {
            SegmentReplicationTarget ongoingReplicationTarget = this.onGoingReplications.getOngoingReplicationTarget(replicaShard.shardId());
            if (ongoingReplicationTarget != null) {
                if (ongoingReplicationTarget.getCheckpoint().getPrimaryTerm() < receivedCheckpoint.getPrimaryTerm()) {
                    logger.debug(() -> new ParameterizedMessage("Cancelling ongoing replication {} from old primary with primary term {}", (Object)ongoingReplicationTarget.description(), (Object)ongoingReplicationTarget.getCheckpoint().getPrimaryTerm()));
                    ongoingReplicationTarget.cancel("Cancelling stuck target after new primary");
                } else {
                    logger.debug(() -> new ParameterizedMessage("Ignoring new replication checkpoint - shard is currently replicating to checkpoint {}", (Object)ongoingReplicationTarget.getCheckpoint()));
                    return;
                }
            }
            final Thread thread = Thread.currentThread();
            if (replicaShard.shouldProcessCheckpoint(receivedCheckpoint)) {
                this.startReplication(replicaShard, receivedCheckpoint, new SegmentReplicationListener(){

                    @Override
                    public void onReplicationDone(SegmentReplicationState state) {
                        logger.debug(() -> new ParameterizedMessage("[shardId {}] [replication id {}] Replication complete to {}, timing data: {}", new Object[]{replicaShard.shardId().getId(), state.getReplicationId(), replicaShard.getLatestReplicationCheckpoint(), state.getTimingData()}));
                        SegmentReplicationTargetService.this.updateVisibleCheckpoint(state.getReplicationId(), replicaShard);
                        SegmentReplicationTargetService.this.processLatestReceivedCheckpoint(replicaShard, thread);
                    }

                    @Override
                    public void onReplicationFailure(SegmentReplicationState state, ReplicationFailedException e, boolean sendShardFailure) {
                        SegmentReplicationTargetService.this.logReplicationFailure(state, e, replicaShard);
                        if (sendShardFailure) {
                            SegmentReplicationTargetService.this.failShard(e, replicaShard);
                        } else {
                            SegmentReplicationTargetService.this.processLatestReceivedCheckpoint(replicaShard, thread);
                        }
                    }
                });
            } else if (replicaShard.isSegmentReplicationAllowed()) {
                long replicationId = -1L;
                this.updateVisibleCheckpoint(-1L, replicaShard);
            }
        } else {
            logger.trace(() -> new ParameterizedMessage("Ignoring checkpoint, shard not started {} {}", (Object)receivedCheckpoint, (Object)replicaShard.state()));
        }
    }

    private void logReplicationFailure(SegmentReplicationState state, ReplicationFailedException e, IndexShard replicaShard) {
        if (ExceptionsHelper.unwrap((Throwable)((Object)e), (Class[])new Class[]{CancellableThreads.ExecutionCancelledException.class}) == null) {
            logger.error(() -> new ParameterizedMessage("[shardId {}] [replication id {}] Replication failed, timing data: {}", new Object[]{replicaShard.shardId(), state.getReplicationId(), state.getTimingData()}), (Throwable)((Object)e));
        } else {
            logger.debug(() -> new ParameterizedMessage("[shardId {}] [replication id {}] Replication cancelled", (Object)replicaShard.shardId(), (Object)state.getReplicationId()), (Throwable)((Object)e));
        }
    }

    protected void updateVisibleCheckpoint(long replicationId, final IndexShard replicaShard) {
        if (!replicaShard.indexSettings().isRemoteStoreEnabled()) {
            return;
        }
        ShardRouting primaryShard = this.clusterService.state().routingTable().shardRoutingTable(replicaShard.shardId()).primaryShard();
        final UpdateVisibleCheckpointRequest request = new UpdateVisibleCheckpointRequest(replicationId, replicaShard.routingEntry().allocationId().getId(), primaryShard.shardId(), this.getPrimaryNode(primaryShard), replicaShard.getLatestReplicationCheckpoint());
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build();
        logger.trace(() -> new ParameterizedMessage("Updating Primary shard that replica {}-{} is synced to checkpoint {}", new Object[]{replicaShard.shardId(), replicaShard.routingEntry().allocationId(), request.getCheckpoint()}));
        RetryableTransportClient transportClient = new RetryableTransportClient(this.transportService, this.getPrimaryNode(primaryShard), this.recoverySettings.internalActionRetryTimeout(), logger);
        ActionListener<Void> listener = new ActionListener<Void>(){

            public void onResponse(Void unused) {
                logger.trace(() -> new ParameterizedMessage("Successfully updated replication checkpoint {} for replica {}", (Object)replicaShard.shardId(), (Object)request.getCheckpoint()));
            }

            public void onFailure(Exception e) {
                logger.error(() -> new ParameterizedMessage("Failed to update visible checkpoint for replica {}, {}:", (Object)replicaShard.shardId(), (Object)request.getCheckpoint()), (Throwable)e);
            }
        };
        transportClient.executeRetryableAction("internal:index/shard/replication/update_visible_checkpoint", request, options, ActionListener.map((ActionListener)listener, r -> null), in -> TransportResponse.Empty.INSTANCE);
    }

    private DiscoveryNode getPrimaryNode(ShardRouting primaryShard) {
        return this.clusterService.state().nodes().get(primaryShard.currentNodeId());
    }

    protected boolean processLatestReceivedCheckpoint(IndexShard replicaShard, Thread thread) {
        ReplicationCheckpoint latestPublishedCheckpoint = this.latestReceivedCheckpoint.get(replicaShard.shardId());
        if (latestPublishedCheckpoint != null) {
            logger.trace(() -> new ParameterizedMessage("Processing latest received checkpoint for shard {} {}", (Object)replicaShard.shardId(), (Object)latestPublishedCheckpoint));
            Runnable runnable = () -> this.onNewCheckpoint(this.latestReceivedCheckpoint.get(replicaShard.shardId()), replicaShard);
            if (thread == Thread.currentThread()) {
                this.threadPool.generic().execute(runnable);
            } else {
                runnable.run();
            }
            return true;
        }
        return false;
    }

    protected void updateLatestReceivedCheckpoint(ReplicationCheckpoint receivedCheckpoint, IndexShard replicaShard) {
        if (this.latestReceivedCheckpoint.get(replicaShard.shardId()) != null) {
            if (receivedCheckpoint.isAheadOf(this.latestReceivedCheckpoint.get(replicaShard.shardId()))) {
                this.latestReceivedCheckpoint.replace(replicaShard.shardId(), receivedCheckpoint);
            }
        } else {
            this.latestReceivedCheckpoint.put(replicaShard.shardId(), receivedCheckpoint);
        }
    }

    public SegmentReplicationTarget startReplication(IndexShard indexShard, ReplicationCheckpoint checkpoint, SegmentReplicationListener listener) {
        SegmentReplicationTarget target = new SegmentReplicationTarget(indexShard, checkpoint, this.sourceFactory.get(indexShard), (ReplicationListener)listener);
        this.startReplication(target);
        return target;
    }

    void startReplication(SegmentReplicationTarget target) {
        long replicationId;
        try {
            replicationId = this.onGoingReplications.startSafe(target, this.recoverySettings.activityTimeout());
        }
        catch (ReplicationFailedException e) {
            target.fail(e, false);
            return;
        }
        logger.trace(() -> new ParameterizedMessage("Added new replication to collection {}", (Object)target.description()));
        this.threadPool.generic().execute(new ReplicationRunner(replicationId));
    }

    private void start(final long replicationId) {
        SegmentReplicationTarget target;
        try (ReplicationCollection.ReplicationRef<SegmentReplicationTarget> replicationRef = this.onGoingReplications.get(replicationId);){
            if (replicationRef == null) {
                return;
            }
            target = (SegmentReplicationTarget)((Object)replicationRef.get());
        }
        target.startReplication(new ActionListener<Void>(){

            public void onResponse(Void o) {
                logger.debug(() -> new ParameterizedMessage("Finished replicating {} marking as done.", (Object)target.description()));
                SegmentReplicationTargetService.this.onGoingReplications.markAsDone(replicationId);
                if (target.state().getIndex().recoveredFileCount() != 0 && target.state().getIndex().recoveredBytes() != 0L) {
                    SegmentReplicationTargetService.this.completedReplications.put(target.shardId(), target.state());
                }
            }

            public void onFailure(Exception e) {
                logger.debug("Replication failed {}", (Object)target.description());
                if (SegmentReplicationTargetService.this.isStoreCorrupt(target) || e instanceof CorruptIndexException || e instanceof OpenSearchCorruptionException) {
                    SegmentReplicationTargetService.this.onGoingReplications.fail(replicationId, new ReplicationFailedException("Store corruption during replication", (Throwable)e), true);
                    return;
                }
                SegmentReplicationTargetService.this.onGoingReplications.fail(replicationId, new ReplicationFailedException("Segment Replication failed", (Throwable)e), false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStoreCorrupt(SegmentReplicationTarget target) {
        Store store;
        if (target.refCount() > 0 && (store = target.store()).tryIncRef()) {
            try {
                boolean bl = store.isMarkedCorrupted();
                return bl;
            }
            catch (IOException ex) {
                logger.warn("Unable to determine if store is corrupt", (Throwable)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                store.decRef();
            }
        }
        return false;
    }

    private void forceReplication(ForceSyncRequest request, final ActionListener<TransportResponse> listener) {
        final ShardId shardId = request.getShardId();
        assert (this.indicesService != null);
        final IndexShard indexShard = (IndexShard)this.indicesService.getShardOrNull(shardId);
        if (indexShard == null || indexShard.getReplicationEngine().isEmpty()) {
            listener.onResponse((Object)TransportResponse.Empty.INSTANCE);
        } else {
            this.startReplication(indexShard, indexShard.getLatestReplicationCheckpoint(), new SegmentReplicationListener(){

                @Override
                public void onReplicationDone(SegmentReplicationState state) {
                    try {
                        logger.trace(() -> new ParameterizedMessage("[shardId {}] [replication id {}] Force replication Sync complete to {}, timing data: {}", new Object[]{shardId, state.getReplicationId(), indexShard.getLatestReplicationCheckpoint(), state.getTimingData()}));
                        if (indexShard.recoveryState().getPrimary()) {
                            indexShard.resetToWriteableEngine();
                        } else {
                            SegmentReplicationTargetService.this.updateVisibleCheckpoint(state.getReplicationId(), indexShard);
                        }
                        listener.onResponse((Object)TransportResponse.Empty.INSTANCE);
                    }
                    catch (Exception e) {
                        logger.error("Error while marking replication completed", (Throwable)e);
                        listener.onFailure(e);
                    }
                }

                @Override
                public void onReplicationFailure(SegmentReplicationState state, ReplicationFailedException e, boolean sendShardFailure) {
                    SegmentReplicationTargetService.this.logReplicationFailure(state, e, indexShard);
                    if (sendShardFailure) {
                        SegmentReplicationTargetService.this.failShard(e, indexShard);
                    }
                    listener.onFailure((Exception)((Object)e));
                }
            });
        }
    }

    private void failShard(ReplicationFailedException e, IndexShard indexShard) {
        try {
            indexShard.failShard("unrecoverable replication failure", (Exception)((Object)e));
        }
        catch (Exception inner) {
            logger.error("Error attempting to fail shard", (Throwable)inner);
            e.addSuppressed(inner);
        }
    }

    private class ForceSyncTransportRequestHandler
    implements TransportRequestHandler<ForceSyncRequest> {
        private ForceSyncTransportRequestHandler() {
        }

        @Override
        public void messageReceived(ForceSyncRequest request, TransportChannel channel, Task task) throws Exception {
            SegmentReplicationTargetService.this.forceReplication(request, new ChannelActionListener(channel, "internal:index/shard/replication/segments_sync", request));
        }
    }

    private class FileChunkTransportRequestHandler
    implements TransportRequestHandler<FileChunkRequest> {
        final AtomicLong bytesSinceLastPause = new AtomicLong();

        private FileChunkTransportRequestHandler() {
        }

        @Override
        public void messageReceived(FileChunkRequest request, TransportChannel channel, Task task) throws Exception {
            try (ReplicationCollection.ReplicationRef<SegmentReplicationTarget> ref = SegmentReplicationTargetService.this.onGoingReplications.getSafe(request.recoveryId(), request.shardId());){
                SegmentReplicationTarget target = (SegmentReplicationTarget)((Object)ref.get());
                ActionListener<Void> listener = target.createOrFinishListener(channel, "internal:index/shard/replication/file_chunk", request);
                target.handleFileChunk(request, target, this.bytesSinceLastPause, SegmentReplicationTargetService.this.recoverySettings.rateLimiter(), listener);
            }
        }
    }

    private class ReplicationRunner
    extends AbstractRunnable {
        final long replicationId;

        public ReplicationRunner(long replicationId) {
            this.replicationId = replicationId;
        }

        @Override
        public void onFailure(Exception e) {
            try (ReplicationCollection.ReplicationRef<SegmentReplicationTarget> ref = SegmentReplicationTargetService.this.onGoingReplications.get(this.replicationId);){
                logger.error(() -> new ParameterizedMessage("Error during segment replication, {}", (Object)((SegmentReplicationTarget)((Object)((Object)ref.get()))).description()), (Throwable)e);
            }
            SegmentReplicationTargetService.this.onGoingReplications.fail(this.replicationId, new ReplicationFailedException("Unexpected Error during replication", (Throwable)e), false);
        }

        @Override
        public void doRun() {
            SegmentReplicationTargetService.this.start(this.replicationId);
        }
    }

    public static interface SegmentReplicationListener
    extends ReplicationListener {
        @Override
        default public void onDone(ReplicationState state) {
            this.onReplicationDone((SegmentReplicationState)state);
        }

        @Override
        default public void onFailure(ReplicationState state, ReplicationFailedException e, boolean sendShardFailure) {
            this.onReplicationFailure((SegmentReplicationState)state, e, sendShardFailure);
        }

        public void onReplicationDone(SegmentReplicationState var1);

        public void onReplicationFailure(SegmentReplicationState var1, ReplicationFailedException var2, boolean var3);
    }

    public static class Actions {
        public static final String FILE_CHUNK = "internal:index/shard/replication/file_chunk";
        public static final String FORCE_SYNC = "internal:index/shard/replication/segments_sync";
    }
}

