/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateApplier;
import org.opensearch.cluster.action.index.NodeMappingRefreshAction;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.env.ShardLockObtainFailedException;
import org.opensearch.gateway.GatewayService;
import org.opensearch.index.IndexComponent;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.remote.RemoteStoreStatsTrackerFactory;
import org.opensearch.index.seqno.GlobalCheckpointSyncAction;
import org.opensearch.index.seqno.RetentionLeaseSyncer;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardState;
import org.opensearch.index.shard.PrimaryReplicaSyncer;
import org.opensearch.index.shard.ShardNotFoundException;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.recovery.PeerRecoverySourceService;
import org.opensearch.indices.recovery.PeerRecoveryTargetService;
import org.opensearch.indices.recovery.RecoveryListener;
import org.opensearch.indices.recovery.RecoveryState;
import org.opensearch.indices.replication.SegmentReplicationSourceService;
import org.opensearch.indices.replication.SegmentReplicationTargetService;
import org.opensearch.indices.replication.checkpoint.SegmentReplicationCheckpointPublisher;
import org.opensearch.indices.replication.common.ReplicationState;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.search.SearchService;
import org.opensearch.snapshots.SnapshotShardsService;
import org.opensearch.threadpool.ThreadPool;

public class IndicesClusterStateService
extends AbstractLifecycleComponent
implements ClusterStateApplier {
    private static final Logger logger = LogManager.getLogger(IndicesClusterStateService.class);
    final AllocatedIndices<? extends Shard, ? extends AllocatedIndex<? extends Shard>> indicesService;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final PeerRecoveryTargetService recoveryTargetService;
    private final ShardStateAction shardStateAction;
    private final NodeMappingRefreshAction nodeMappingRefreshAction;
    private static final ActionListener<Void> SHARD_STATE_ACTION_LISTENER = ActionListener.wrap(() -> {});
    private final Settings settings;
    final ConcurrentMap<ShardId, ShardRouting> failedShardsCache = ConcurrentCollections.newConcurrentMap();
    private final RepositoriesService repositoriesService;
    private final FailedShardHandler failedShardHandler = new FailedShardHandler();
    private final boolean sendRefreshMapping;
    private final List<IndexEventListener> builtInIndexListener;
    private final PrimaryReplicaSyncer primaryReplicaSyncer;
    private final Consumer<ShardId> globalCheckpointSyncer;
    private final RetentionLeaseSyncer retentionLeaseSyncer;
    private final SegmentReplicationTargetService segmentReplicationTargetService;
    private final SegmentReplicationCheckpointPublisher checkpointPublisher;
    private final RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory;

    @Inject
    public IndicesClusterStateService(Settings settings, IndicesService indicesService, ClusterService clusterService, ThreadPool threadPool, PeerRecoveryTargetService recoveryTargetService, SegmentReplicationTargetService segmentReplicationTargetService, SegmentReplicationSourceService segmentReplicationSourceService, ShardStateAction shardStateAction, NodeMappingRefreshAction nodeMappingRefreshAction, RepositoriesService repositoriesService, SearchService searchService, PeerRecoverySourceService peerRecoverySourceService, SnapshotShardsService snapshotShardsService, PrimaryReplicaSyncer primaryReplicaSyncer, GlobalCheckpointSyncAction globalCheckpointSyncAction, RetentionLeaseSyncer retentionLeaseSyncer, SegmentReplicationCheckpointPublisher checkpointPublisher, RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory) {
        this(settings, (AllocatedIndices<? extends Shard, ? extends AllocatedIndex<? extends Shard>>)indicesService, clusterService, threadPool, checkpointPublisher, segmentReplicationTargetService, segmentReplicationSourceService, recoveryTargetService, shardStateAction, nodeMappingRefreshAction, repositoriesService, searchService, peerRecoverySourceService, snapshotShardsService, primaryReplicaSyncer, globalCheckpointSyncAction::updateGlobalCheckpointForShard, retentionLeaseSyncer, remoteStoreStatsTrackerFactory);
    }

    IndicesClusterStateService(Settings settings, AllocatedIndices<? extends Shard, ? extends AllocatedIndex<? extends Shard>> indicesService, ClusterService clusterService, ThreadPool threadPool, SegmentReplicationCheckpointPublisher checkpointPublisher, SegmentReplicationTargetService segmentReplicationTargetService, SegmentReplicationSourceService segmentReplicationSourceService, PeerRecoveryTargetService recoveryTargetService, ShardStateAction shardStateAction, NodeMappingRefreshAction nodeMappingRefreshAction, RepositoriesService repositoriesService, SearchService searchService, PeerRecoverySourceService peerRecoverySourceService, SnapshotShardsService snapshotShardsService, PrimaryReplicaSyncer primaryReplicaSyncer, Consumer<ShardId> globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory) {
        this.settings = settings;
        this.checkpointPublisher = checkpointPublisher;
        ArrayList<IndexEventListener> indexEventListeners = new ArrayList<IndexEventListener>(Arrays.asList(peerRecoverySourceService, recoveryTargetService, searchService, snapshotShardsService));
        indexEventListeners.add(segmentReplicationTargetService);
        indexEventListeners.add(segmentReplicationSourceService);
        indexEventListeners.add(remoteStoreStatsTrackerFactory);
        this.segmentReplicationTargetService = segmentReplicationTargetService;
        this.builtInIndexListener = Collections.unmodifiableList(indexEventListeners);
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.recoveryTargetService = recoveryTargetService;
        this.shardStateAction = shardStateAction;
        this.nodeMappingRefreshAction = nodeMappingRefreshAction;
        this.repositoriesService = repositoriesService;
        this.primaryReplicaSyncer = primaryReplicaSyncer;
        this.globalCheckpointSyncer = globalCheckpointSyncer;
        this.retentionLeaseSyncer = Objects.requireNonNull(retentionLeaseSyncer);
        this.sendRefreshMapping = settings.getAsBoolean("indices.cluster.send_refresh_mapping", true);
        this.remoteStoreStatsTrackerFactory = remoteStoreStatsTrackerFactory;
    }

    protected void doStart() {
        if (DiscoveryNode.isDataNode(this.settings) || DiscoveryNode.isClusterManagerNode(this.settings)) {
            this.clusterService.addHighPriorityApplier(this);
        }
    }

    protected void doStop() {
        if (DiscoveryNode.isDataNode(this.settings) || DiscoveryNode.isClusterManagerNode(this.settings)) {
            this.clusterService.removeApplier(this);
        }
    }

    protected void doClose() {
    }

    @Override
    public synchronized void applyClusterState(ClusterChangedEvent event) {
        if (!this.lifecycle.started()) {
            return;
        }
        ClusterState state = event.state();
        if (state.blocks().disableStatePersistence()) {
            for (AllocatedIndex indexService : this.indicesService) {
                this.indicesService.removeIndex(indexService.index(), AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, "cleaning index (disabled block persistence)");
            }
            return;
        }
        this.updateFailedShardsCache(state);
        this.deleteIndices(event);
        this.removeIndices(event);
        this.failMissingShards(state);
        this.removeShards(state);
        this.updateIndices(event);
        this.createIndices(state);
        this.createOrUpdateShards(state);
    }

    private void updateFailedShardsCache(ClusterState state) {
        RoutingNode localRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
        if (localRoutingNode == null) {
            this.failedShardsCache.clear();
            return;
        }
        DiscoveryNode clusterManagerNode = state.nodes().getClusterManagerNode();
        Iterator iterator = this.failedShardsCache.entrySet().iterator();
        while (iterator.hasNext()) {
            ShardRouting failedShardRouting = (ShardRouting)iterator.next().getValue();
            ShardRouting matchedRouting = localRoutingNode.getByShardId(failedShardRouting.shardId());
            if (matchedRouting == null || !matchedRouting.isSameAllocation(failedShardRouting)) {
                iterator.remove();
                continue;
            }
            if (clusterManagerNode == null) continue;
            String message = "cluster-manager " + clusterManagerNode + " has not removed previously failed shard. resending shard failure";
            logger.trace("[{}] re-sending failed shard [{}], reason [{}]", (Object)matchedRouting.shardId(), (Object)matchedRouting, (Object)message);
            this.shardStateAction.localShardFailed(matchedRouting, message, null, SHARD_STATE_ACTION_LISTENER, state);
        }
    }

    private void deleteIndices(ClusterChangedEvent event) {
        ClusterState previousState = event.previousState();
        ClusterState state = event.state();
        String localNodeId = state.nodes().getLocalNodeId();
        assert (localNodeId != null);
        for (final Index index : event.indicesDeleted()) {
            IndexMetadata metadata;
            IndexSettings indexSettings;
            AllocatedIndex<? extends Shard> indexService;
            if (logger.isDebugEnabled()) {
                logger.debug("[{}] cleaning index, no longer part of the metadata", (Object)index);
            }
            if ((indexService = this.indicesService.indexService(index)) != null) {
                indexSettings = indexService.getIndexSettings();
                this.indicesService.removeIndex(index, AllocatedIndices.IndexRemovalReason.DELETED, "index no longer part of the metadata");
            } else if (previousState.metadata().hasIndex(index)) {
                metadata = previousState.metadata().index(index);
                indexSettings = new IndexSettings(metadata, this.settings);
                this.indicesService.deleteUnassignedIndex("deleted index was not assigned to local node", metadata, state);
            } else {
                assert (state.metadata().indexGraveyard().containsIndex(index) || previousState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK));
                metadata = this.indicesService.verifyIndexIsDeleted(index, event.state());
                indexSettings = metadata != null ? new IndexSettings(metadata, this.settings) : null;
            }
            if (indexSettings == null) continue;
            this.threadPool.generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.warn(() -> new ParameterizedMessage("[{}] failed to complete pending deletion for index", (Object)index), (Throwable)e);
                }

                @Override
                protected void doRun() throws Exception {
                    try {
                        IndicesClusterStateService.this.indicesService.processPendingDeletes(index, indexSettings, new TimeValue(30L, TimeUnit.MINUTES));
                    }
                    catch (ShardLockObtainFailedException exc) {
                        logger.warn("[{}] failed to lock all shards for index - timed out after 30 seconds", (Object)index);
                    }
                    catch (InterruptedException e) {
                        logger.warn("[{}] failed to lock all shards for index - interrupted", (Object)index);
                    }
                }
            });
        }
    }

    private void removeIndices(ClusterChangedEvent event) {
        ClusterState state = event.state();
        String localNodeId = state.nodes().getLocalNodeId();
        assert (localNodeId != null);
        HashSet<Index> indicesWithShards = new HashSet<Index>();
        RoutingNode localRoutingNode = state.getRoutingNodes().node(localNodeId);
        if (localRoutingNode != null) {
            for (ShardRouting shardRouting : localRoutingNode) {
                indicesWithShards.add(shardRouting.index());
            }
        }
        for (AllocatedIndex indexService : this.indicesService) {
            Index index = indexService.index();
            IndexMetadata indexMetadata = state.metadata().index(index);
            IndexMetadata existingMetadata = indexService.getIndexSettings().getIndexMetadata();
            AllocatedIndices.IndexRemovalReason reason = null;
            if (indexMetadata != null && indexMetadata.getState() != existingMetadata.getState()) {
                reason = indexMetadata.getState() == IndexMetadata.State.CLOSE ? AllocatedIndices.IndexRemovalReason.CLOSED : AllocatedIndices.IndexRemovalReason.REOPENED;
            } else if (!indicesWithShards.contains(index)) {
                assert (indexMetadata != null || event.isNewCluster()) : "index " + index + " does not exist in the cluster state, it should either have been deleted or the cluster must be new";
                AllocatedIndices.IndexRemovalReason indexRemovalReason = reason = indexMetadata != null && indexMetadata.getState() == IndexMetadata.State.CLOSE ? AllocatedIndices.IndexRemovalReason.CLOSED : AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED;
            }
            if (reason == null) continue;
            logger.debug("{} removing index ({})", (Object)index, (Object)reason);
            this.indicesService.removeIndex(index, reason, "removing index (" + reason + ")");
        }
    }

    private void failMissingShards(ClusterState state) {
        RoutingNode localRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
        if (localRoutingNode == null) {
            return;
        }
        for (ShardRouting shardRouting : localRoutingNode) {
            ShardId shardId = shardRouting.shardId();
            if (shardRouting.initializing() || this.failedShardsCache.containsKey(shardId) || this.indicesService.getShardOrNull(shardId) != null) continue;
            this.sendFailShard(shardRouting, "master marked shard as active, but shard has not been created, mark shard as failed", null, state);
        }
    }

    private void removeShards(ClusterState state) {
        String localNodeId = state.nodes().getLocalNodeId();
        assert (localNodeId != null);
        RoutingNode localRoutingNode = state.getRoutingNodes().node(localNodeId);
        for (AllocatedIndex indexService : this.indicesService) {
            for (Shard shard : indexService) {
                ShardRouting newShardRouting;
                ShardRouting currentRoutingEntry = shard.routingEntry();
                ShardId shardId = currentRoutingEntry.shardId();
                ShardRouting shardRouting = newShardRouting = localRoutingNode == null ? null : localRoutingNode.getByShardId(shardId);
                if (newShardRouting == null) {
                    logger.debug("{} removing shard (not allocated)", (Object)shardId);
                    indexService.removeShard(shardId.id(), "removing shard (not allocated)");
                    continue;
                }
                if (!newShardRouting.isSameAllocation(currentRoutingEntry)) {
                    logger.debug("{} removing shard (stale allocation id, stale {}, new {})", (Object)shardId, (Object)currentRoutingEntry, (Object)newShardRouting);
                    indexService.removeShard(shardId.id(), "removing shard (stale copy)");
                    continue;
                }
                if (newShardRouting.initializing() && currentRoutingEntry.active()) {
                    logger.debug("{} removing shard (not active, current {}, new {})", (Object)shardId, (Object)currentRoutingEntry, (Object)newShardRouting);
                    indexService.removeShard(shardId.id(), "removing shard (stale copy)");
                    continue;
                }
                if (!newShardRouting.primary() || currentRoutingEntry.primary() || !newShardRouting.initializing()) continue;
                assert (currentRoutingEntry.initializing()) : currentRoutingEntry;
                logger.debug("{} removing shard (not active, current {}, new {})", (Object)shardId, (Object)currentRoutingEntry, (Object)newShardRouting);
                indexService.removeShard(shardId.id(), "removing shard (stale copy)");
            }
        }
    }

    private void createIndices(ClusterState state) {
        Index index;
        RoutingNode localRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
        if (localRoutingNode == null) {
            return;
        }
        HashMap<Index, List> indicesToCreate = new HashMap<Index, List>();
        for (ShardRouting shardRouting : localRoutingNode) {
            if (this.failedShardsCache.containsKey(shardRouting.shardId()) || this.indicesService.indexService(index = shardRouting.index()) != null) continue;
            indicesToCreate.computeIfAbsent(index, k -> new ArrayList()).add(shardRouting);
        }
        for (Map.Entry entry : indicesToCreate.entrySet()) {
            index = (Index)entry.getKey();
            IndexMetadata indexMetadata = state.metadata().index(index);
            logger.debug("[{}] creating index", (Object)index);
            AllocatedIndex<? extends Shard> indexService = null;
            try {
                ArrayList<IndexEventListener> updatedIndexEventListeners = new ArrayList<IndexEventListener>(this.builtInIndexListener);
                if (((List)entry.getValue()).size() > 0 && ((ShardRouting)((List)entry.getValue()).get(0)).recoverySource().getType() == RecoverySource.Type.SNAPSHOT && indexMetadata.getSettings().getAsBoolean("index.remote_store.enabled", false).booleanValue()) {
                    IndexEventListener refreshListenerAfterSnapshotRestore = new IndexEventListener(){

                        @Override
                        public void afterIndexShardStarted(IndexShard indexShard) {
                            indexShard.refresh("refresh to upload metadata to remote store");
                        }
                    };
                    updatedIndexEventListeners.add(refreshListenerAfterSnapshotRestore);
                }
                if (!(indexService = this.indicesService.createIndex(indexMetadata, updatedIndexEventListeners, true)).updateMapping(null, indexMetadata) || !this.sendRefreshMapping) continue;
                this.nodeMappingRefreshAction.nodeMappingRefresh(state.nodes().getClusterManagerNode(), new NodeMappingRefreshAction.NodeMappingRefreshRequest(indexMetadata.getIndex().getName(), indexMetadata.getIndexUUID(), state.nodes().getLocalNodeId()));
            }
            catch (Exception e) {
                String failShardReason;
                if (indexService == null) {
                    failShardReason = "failed to create index";
                } else {
                    failShardReason = "failed to update mapping for index";
                    this.indicesService.removeIndex(index, AllocatedIndices.IndexRemovalReason.FAILURE, "removing index (mapping update failed)");
                }
                for (ShardRouting shardRouting : (List)entry.getValue()) {
                    this.sendFailShard(shardRouting, failShardReason, e, state);
                }
            }
        }
    }

    private void updateIndices(ClusterChangedEvent event) {
        if (!event.metadataChanged()) {
            return;
        }
        ClusterState state = event.state();
        for (AllocatedIndex indexService : this.indicesService) {
            Index index = indexService.index();
            IndexMetadata currentIndexMetadata = indexService.getIndexSettings().getIndexMetadata();
            IndexMetadata newIndexMetadata = state.metadata().index(index);
            assert (newIndexMetadata != null) : "index " + index + " should have been removed by deleteIndices";
            if (!ClusterChangedEvent.indexMetadataChanged(currentIndexMetadata, newIndexMetadata)) continue;
            String reason = null;
            try {
                reason = "metadata update failed";
                try {
                    indexService.updateMetadata(currentIndexMetadata, newIndexMetadata);
                }
                catch (Exception e) {
                    assert (false) : e;
                    throw e;
                }
                reason = "mapping update failed";
                if (!indexService.updateMapping(currentIndexMetadata, newIndexMetadata) || !this.sendRefreshMapping) continue;
                this.nodeMappingRefreshAction.nodeMappingRefresh(state.nodes().getClusterManagerNode(), new NodeMappingRefreshAction.NodeMappingRefreshRequest(newIndexMetadata.getIndex().getName(), newIndexMetadata.getIndexUUID(), state.nodes().getLocalNodeId()));
            }
            catch (Exception e) {
                this.indicesService.removeIndex(indexService.index(), AllocatedIndices.IndexRemovalReason.FAILURE, "removing index (" + reason + ")");
                RoutingNode localRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
                if (localRoutingNode == null) continue;
                for (ShardRouting shardRouting : localRoutingNode) {
                    if (!shardRouting.index().equals((Object)index) || this.failedShardsCache.containsKey(shardRouting.shardId())) continue;
                    this.sendFailShard(shardRouting, "failed to update index (" + reason + ")", e, state);
                }
            }
        }
    }

    private void createOrUpdateShards(ClusterState state) {
        RoutingNode localRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
        if (localRoutingNode == null) {
            return;
        }
        DiscoveryNodes nodes = state.nodes();
        RoutingTable routingTable = state.routingTable();
        for (ShardRouting shardRouting : localRoutingNode) {
            ShardId shardId = shardRouting.shardId();
            if (this.failedShardsCache.containsKey(shardId)) continue;
            AllocatedIndex<? extends Shard> indexService = this.indicesService.indexService(shardId.getIndex());
            assert (indexService != null) : "index " + shardId.getIndex() + " should have been created by createIndices";
            Shard shard = indexService.getShardOrNull(shardId.id());
            if (shard == null) {
                assert (shardRouting.initializing()) : shardRouting + " should have been removed by failMissingShards";
                this.createShard(nodes, routingTable, shardRouting, state);
                continue;
            }
            this.updateShard(nodes, shardRouting, shard, routingTable, state);
        }
    }

    private void createShard(DiscoveryNodes nodes, RoutingTable routingTable, ShardRouting shardRouting, ClusterState state) {
        assert (shardRouting.initializing()) : "only allow shard creation for initializing shard but was " + shardRouting;
        DiscoveryNode sourceNode = null;
        if (shardRouting.recoverySource().getType() == RecoverySource.Type.PEER && (sourceNode = IndicesClusterStateService.findSourceNodeForPeerRecovery(logger, routingTable, nodes, shardRouting)) == null) {
            logger.trace("ignoring initializing shard {} - no source node can be found.", (Object)shardRouting.shardId());
            return;
        }
        try {
            long primaryTerm = state.metadata().index(shardRouting.index()).primaryTerm(shardRouting.id());
            logger.debug("{} creating shard with primary term [{}]", (Object)shardRouting.shardId(), (Object)primaryTerm);
            this.indicesService.createShard(shardRouting, this.checkpointPublisher, this.recoveryTargetService, new RecoveryListener(shardRouting, primaryTerm, this), this.repositoriesService, this.failedShardHandler, this.globalCheckpointSyncer, this.retentionLeaseSyncer, nodes.getLocalNode(), sourceNode, this.remoteStoreStatsTrackerFactory);
        }
        catch (Exception e) {
            this.failAndRemoveShard(shardRouting, true, "failed to create shard", e, state);
        }
    }

    private void updateShard(DiscoveryNodes nodes, ShardRouting shardRouting, Shard shard, RoutingTable routingTable, ClusterState clusterState) {
        long primaryTerm;
        ShardRouting currentRoutingEntry = shard.routingEntry();
        assert (currentRoutingEntry.isSameAllocation(shardRouting)) : "local shard has a different allocation id but wasn't cleaned by removeShards. cluster state: " + shardRouting + " local: " + currentRoutingEntry;
        try {
            IndexMetadata indexMetadata = clusterState.metadata().index(shard.shardId().getIndex());
            primaryTerm = indexMetadata.primaryTerm(shard.shardId().id());
            Set<String> inSyncIds = indexMetadata.inSyncAllocationIds(shard.shardId().id());
            IndexShardRoutingTable indexShardRoutingTable = routingTable.shardRoutingTable(shardRouting.shardId());
            shard.updateShardState(shardRouting, primaryTerm, this.primaryReplicaSyncer::resync, clusterState.version(), inSyncIds, indexShardRoutingTable);
        }
        catch (Exception e) {
            this.failAndRemoveShard(shardRouting, true, "failed updating shard routing entry", e, clusterState);
            return;
        }
        IndexShardState state = shard.state();
        if (shardRouting.initializing() && (state == IndexShardState.STARTED || state == IndexShardState.POST_RECOVERY)) {
            if (logger.isTraceEnabled()) {
                logger.trace("{} cluster-manager marked shard as initializing, but shard has state [{}], resending shard started to {}", (Object)shardRouting.shardId(), (Object)state, (Object)nodes.getClusterManagerNode());
            }
            if (nodes.getClusterManagerNode() != null) {
                this.shardStateAction.shardStarted(shardRouting, primaryTerm, "cluster-manager " + nodes.getClusterManagerNode() + " marked shard as initializing, but shard state is [" + state + "], mark shard as started", SHARD_STATE_ACTION_LISTENER, clusterState);
            }
        }
    }

    private static DiscoveryNode findSourceNodeForPeerRecovery(Logger logger, RoutingTable routingTable, DiscoveryNodes nodes, ShardRouting shardRouting) {
        DiscoveryNode sourceNode = null;
        if (!shardRouting.primary()) {
            ShardRouting primary = routingTable.shardRoutingTable(shardRouting.shardId()).primaryShard();
            if (primary.active()) {
                sourceNode = nodes.get(primary.currentNodeId());
                if (sourceNode == null) {
                    logger.trace("can't find replica source node because primary shard {} is assigned to an unknown node.", (Object)primary);
                }
            } else {
                logger.trace("can't find replica source node because primary shard {} is not active.", (Object)primary);
            }
        } else if (shardRouting.relocatingNodeId() != null) {
            sourceNode = nodes.get(shardRouting.relocatingNodeId());
            if (sourceNode == null) {
                logger.trace("can't find relocation source node for shard {} because it is assigned to an unknown node [{}].", (Object)shardRouting.shardId(), (Object)shardRouting.relocatingNodeId());
            }
        } else {
            throw new IllegalStateException("trying to find source node for peer recovery when routing state means no peer recovery: " + shardRouting);
        }
        return sourceNode;
    }

    public synchronized void handleRecoveryFailure(ShardRouting shardRouting, boolean sendShardFailure, Exception failure) {
        this.failAndRemoveShard(shardRouting, sendShardFailure, "failed recovery", failure, this.clusterService.state());
    }

    public void handleRecoveryDone(ReplicationState state, ShardRouting shardRouting, long primaryTerm) {
        RecoveryState recoveryState = (RecoveryState)state;
        this.shardStateAction.shardStarted(shardRouting, primaryTerm, "after " + recoveryState.getRecoverySource(), SHARD_STATE_ACTION_LISTENER);
    }

    private void failAndRemoveShard(ShardRouting shardRouting, boolean sendShardFailure, String message, @Nullable Exception failure, ClusterState state) {
        try {
            Shard shard;
            AllocatedIndex<? extends Shard> indexService = this.indicesService.indexService(shardRouting.shardId().getIndex());
            if (indexService != null && (shard = indexService.getShardOrNull(shardRouting.shardId().id())) != null && shard.routingEntry().isSameAllocation(shardRouting)) {
                indexService.removeShard(shardRouting.shardId().id(), message);
            }
        }
        catch (ShardNotFoundException indexService) {
        }
        catch (Exception inner) {
            inner.addSuppressed(failure);
            logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to remove shard after failure ([{}])", new Object[]{shardRouting.getIndexName(), shardRouting.getId(), message}), (Throwable)inner);
        }
        if (sendShardFailure) {
            this.sendFailShard(shardRouting, message, failure, state);
        }
    }

    private void sendFailShard(ShardRouting shardRouting, String message, @Nullable Exception failure, ClusterState state) {
        try {
            logger.warn(() -> new ParameterizedMessage("{} marking and sending shard failed due to [{}]", (Object)shardRouting.shardId(), (Object)message), (Throwable)failure);
            this.failedShardsCache.put(shardRouting.shardId(), shardRouting);
            this.shardStateAction.localShardFailed(shardRouting, message, failure, SHARD_STATE_ACTION_LISTENER, state);
        }
        catch (Exception inner) {
            if (failure != null) {
                inner.addSuppressed(failure);
            }
            logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to mark shard as failed (because of [{}])", new Object[]{shardRouting.getIndexName(), shardRouting.getId(), message}), (Throwable)inner);
        }
    }

    public static interface AllocatedIndices<T extends Shard, U extends AllocatedIndex<T>>
    extends Iterable<U> {
        public U createIndex(IndexMetadata var1, List<IndexEventListener> var2, boolean var3) throws IOException;

        public IndexMetadata verifyIndexIsDeleted(Index var1, ClusterState var2);

        public void deleteUnassignedIndex(String var1, IndexMetadata var2, ClusterState var3);

        public void removeIndex(Index var1, IndexRemovalReason var2, String var3);

        @Nullable
        public U indexService(Index var1);

        public T createShard(ShardRouting var1, SegmentReplicationCheckpointPublisher var2, PeerRecoveryTargetService var3, RecoveryListener var4, RepositoriesService var5, Consumer<IndexShard.ShardFailure> var6, Consumer<ShardId> var7, RetentionLeaseSyncer var8, DiscoveryNode var9, @Nullable DiscoveryNode var10, RemoteStoreStatsTrackerFactory var11) throws IOException;

        default public T getShardOrNull(ShardId shardId) {
            U indexRef = this.indexService(shardId.getIndex());
            if (indexRef != null) {
                return indexRef.getShardOrNull(shardId.id());
            }
            return null;
        }

        public void processPendingDeletes(Index var1, IndexSettings var2, TimeValue var3) throws IOException, InterruptedException, ShardLockObtainFailedException;

        @PublicApi(since="1.0.0")
        public static enum IndexRemovalReason {
            NO_LONGER_ASSIGNED,
            DELETED,
            CLOSED,
            FAILURE,
            REOPENED;

        }
    }

    public static interface AllocatedIndex<T extends Shard>
    extends Iterable<T>,
    IndexComponent {
        public IndexSettings getIndexSettings();

        public void updateMetadata(IndexMetadata var1, IndexMetadata var2);

        public boolean updateMapping(IndexMetadata var1, IndexMetadata var2) throws IOException;

        @Nullable
        public T getShardOrNull(int var1);

        public void removeShard(int var1, String var2);
    }

    public static interface Shard {
        public ShardId shardId();

        public ShardRouting routingEntry();

        public IndexShardState state();

        public RecoveryState recoveryState();

        public void updateShardState(ShardRouting var1, long var2, BiConsumer<IndexShard, ActionListener<PrimaryReplicaSyncer.ResyncTask>> var4, long var5, Set<String> var7, IndexShardRoutingTable var8) throws IOException;
    }

    private class FailedShardHandler
    implements Consumer<IndexShard.ShardFailure> {
        private FailedShardHandler() {
        }

        @Override
        public void accept(IndexShard.ShardFailure shardFailure) {
            ShardRouting shardRouting = shardFailure.routing;
            IndicesClusterStateService.this.threadPool.generic().execute(() -> {
                IndicesClusterStateService indicesClusterStateService = IndicesClusterStateService.this;
                synchronized (indicesClusterStateService) {
                    IndicesClusterStateService.this.failAndRemoveShard(shardRouting, true, "shard failure, reason [" + shardFailure.reason + "]", shardFailure.cause, IndicesClusterStateService.this.clusterService.state());
                }
            });
        }
    }
}

