/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.exc.InputCoercionException;
import java.io.IOException;
import java.math.BigInteger;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.sandbox.document.BigIntegerPoint;
import org.apache.lucene.sandbox.document.HalfFloatPoint;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.common.Explicit;
import org.opensearch.common.Numbers;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.document.SortedUnsignedLongDocValuesRangeQuery;
import org.opensearch.index.document.SortedUnsignedLongDocValuesSetQuery;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexNumericFieldData;
import org.opensearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SimpleMappedFieldType;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.lookup.SearchLookup;

public class NumberFieldMapper
extends ParametrizedFieldMapper {
    public static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private final NumberType type;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final Explicit<Boolean> ignoreMalformed;
    private final Explicit<Boolean> coerce;
    private final Number nullValue;
    private final boolean ignoreMalformedByDefault;
    private final boolean coerceByDefault;

    private static NumberFieldMapper toType(FieldMapper in) {
        return (NumberFieldMapper)in;
    }

    private NumberFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.type = builder.type;
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.stored = builder.stored.getValue();
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.coerce = builder.coerce.getValue();
        this.nullValue = builder.nullValue.getValue();
        this.ignoreMalformedByDefault = (Boolean)builder.ignoreMalformed.getDefaultValue().value();
        this.coerceByDefault = (Boolean)builder.coerce.getDefaultValue().value();
    }

    boolean coerce() {
        return (Boolean)this.coerce.value();
    }

    boolean ignoreMalformed() {
        return (Boolean)this.ignoreMalformed.value();
    }

    @Override
    public NumberFieldType fieldType() {
        return (NumberFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().type.typeName();
    }

    @Override
    protected NumberFieldMapper clone() {
        return (NumberFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        Object value;
        XContentParser parser = context.parser();
        Number numericValue = null;
        if (context.externalValueSet()) {
            value = context.externalValue();
        } else if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            value = null;
        } else if (((Boolean)this.coerce.value()).booleanValue() && parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
            value = null;
        } else {
            try {
                numericValue = this.fieldType().type.parse(parser, (boolean)((Boolean)this.coerce.value()));
            }
            catch (JsonParseException | InputCoercionException | IllegalArgumentException e) {
                if (((Boolean)this.ignoreMalformed.value()).booleanValue() && parser.currentToken().isValue()) {
                    context.addIgnoredField(this.mappedFieldType.name());
                    return;
                }
                throw e;
            }
            value = numericValue;
        }
        if (value == null) {
            value = this.nullValue;
        }
        if (value == null) {
            return;
        }
        if (numericValue == null) {
            numericValue = this.fieldType().type.parse(value, (boolean)((Boolean)this.coerce.value()));
        }
        context.doc().addAll(this.fieldType().type.createFields(this.fieldType().name(), numericValue, this.indexed, this.hasDocValues, this.stored));
        if (!this.hasDocValues && (this.stored || this.indexed)) {
            this.createFieldNamesField(context);
        }
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.type, this.ignoreMalformedByDefault, this.coerceByDefault).init(this);
    }

    public static class NumberFieldType
    extends SimpleMappedFieldType {
        private final NumberType type;
        private final boolean coerce;
        private final Number nullValue;

        public NumberFieldType(String name, NumberType type, boolean isSearchable, boolean isStored, boolean hasDocValues, boolean coerce, Number nullValue, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.type = Objects.requireNonNull(type);
            this.coerce = coerce;
            this.nullValue = nullValue;
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        NumberFieldType(String name, Builder builder) {
            this(name, builder.type, builder.indexed.getValue(), builder.stored.getValue(), builder.hasDocValues.getValue(), (Boolean)builder.coerce.getValue().value(), builder.nullValue.getValue(), builder.meta.getValue());
        }

        public NumberFieldType(String name, NumberType type) {
            this(name, type, true, false, true, true, null, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return this.type.name;
        }

        public IndexNumericFieldData.NumericType numericType() {
            return this.type.numericType();
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            Query query = this.type.termQuery(this.name(), value, this.hasDocValues(), this.isSearchable());
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        public Query termsQuery(List values, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            Query query = this.type.termsQuery(this.name(), values, this.hasDocValues(), this.isSearchable());
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            Query query = this.type.rangeQuery(this.name(), lowerTerm, upperTerm, includeLower, includeUpper, this.hasDocValues(), this.isSearchable(), context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Function<byte[], Number> pointReaderIfPossible() {
            if (this.isSearchable()) {
                return this::parsePoint;
            }
            return null;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), this.type.numericType());
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return this.type.valueForSearch((String)value);
            }
            return this.type.valueForSearch((Number)value);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected Object parseSourceValue(Object value) {
                    if (value.equals("")) {
                        return nullValue;
                    }
                    return type.parse(value, coerce);
                }
            };
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            if (format == null) {
                if (this.type == NumberType.UNSIGNED_LONG) {
                    return DocValueFormat.UNSIGNED_LONG;
                }
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }

        public Number parsePoint(byte[] value) {
            return this.type.parsePoint(value);
        }
    }

    public static enum NumberType {
        HALF_FLOAT("half_float", IndexNumericFieldData.NumericType.HALF_FLOAT){

            @Override
            public Float parse(Object value, boolean coerce) {
                float result;
                if (value instanceof Number) {
                    result = ((Number)value).floatValue();
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    result = Float.parseFloat(value.toString());
                }
                this.validateParsed(result);
                return Float.valueOf(result);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return Float.valueOf(HalfFloatPoint.decodeDimension((byte[])value, (int)0));
            }

            @Override
            public Float parse(XContentParser parser, boolean coerce) throws IOException {
                float parsed = parser.floatValue(coerce);
                this.validateParsed(parsed);
                return Float.valueOf(parsed);
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                float v = this.parse(value, false).floatValue();
                if (isSearchable && hasDocValues) {
                    Query query = HalfFloatPoint.newExactQuery((String)field, (float)v);
                    Query dvQuery = SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)HalfFloatPoint.halfFloatToSortableShort((float)v));
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)HalfFloatPoint.halfFloatToSortableShort((float)v));
                }
                return HalfFloatPoint.newExactQuery((String)field, (float)v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocValues, boolean isSearchable) {
                float[] v = new float[values.size()];
                long[] points = new long[v.length];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false).floatValue();
                    if (!hasDocValues) continue;
                    points[i] = HalfFloatPoint.halfFloatToSortableShort((float)v[i]);
                }
                if (isSearchable && hasDocValues) {
                    Query query = HalfFloatPoint.newSetQuery((String)field, (float[])v);
                    Query dvQuery = SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])points);
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])points);
                }
                return HalfFloatPoint.newSetQuery((String)field, (float[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false).floatValue();
                    if (includeLower) {
                        l = HalfFloatPoint.nextDown((float)l);
                    }
                    l = HalfFloatPoint.nextUp((float)l);
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false).floatValue();
                    if (includeUpper) {
                        u = HalfFloatPoint.nextUp((float)u);
                    }
                    u = HalfFloatPoint.nextDown((float)u);
                }
                if (isSearchable && hasDocValues) {
                    Query query = HalfFloatPoint.newRangeQuery((String)field, (float)l, (float)u);
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)HalfFloatPoint.halfFloatToSortableShort((float)l), (long)HalfFloatPoint.halfFloatToSortableShort((float)u));
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)HalfFloatPoint.halfFloatToSortableShort((float)l), (long)HalfFloatPoint.halfFloatToSortableShort((float)u));
                }
                return HalfFloatPoint.newRangeQuery((String)field, (float)l, (float)u);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new HalfFloatPoint(name, new float[]{value.floatValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, (long)HalfFloatPoint.halfFloatToSortableShort((float)value.floatValue())));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.floatValue()));
                }
                return fields;
            }

            @Override
            Number valueForSearch(String value) {
                return Float.valueOf(Float.parseFloat(value));
            }

            private void validateParsed(float value) {
                if (!Float.isFinite(HalfFloatPoint.sortableShortToHalfFloat((short)HalfFloatPoint.halfFloatToSortableShort((float)value)))) {
                    throw new IllegalArgumentException("[half_float] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        FLOAT("float", IndexNumericFieldData.NumericType.FLOAT){

            @Override
            public Float parse(Object value, boolean coerce) {
                float result;
                if (value instanceof Number) {
                    result = ((Number)value).floatValue();
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    result = Float.parseFloat(value.toString());
                }
                this.validateParsed(result);
                return Float.valueOf(result);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return Float.valueOf(FloatPoint.decodeDimension((byte[])value, (int)0));
            }

            @Override
            public Float parse(XContentParser parser, boolean coerce) throws IOException {
                float parsed = parser.floatValue(coerce);
                this.validateParsed(parsed);
                return Float.valueOf(parsed);
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                float v = this.parse(value, false).floatValue();
                if (isSearchable && hasDocValues) {
                    Query query = FloatPoint.newExactQuery((String)field, (float)v);
                    Query dvQuery = SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)NumericUtils.floatToSortableInt((float)v));
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)NumericUtils.floatToSortableInt((float)v));
                }
                return FloatPoint.newExactQuery((String)field, (float)v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocValues, boolean isSearchable) {
                float[] v = new float[values.size()];
                long[] points = new long[v.length];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false).floatValue();
                    if (!hasDocValues) continue;
                    points[i] = NumericUtils.floatToSortableInt((float)v[i]);
                }
                if (isSearchable && hasDocValues) {
                    return new IndexOrDocValuesQuery(FloatPoint.newSetQuery((String)field, (float[])v), SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])points));
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])points);
                }
                return FloatField.newSetQuery((String)field, (float[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false).floatValue();
                    if (!includeLower) {
                        l = FloatPoint.nextUp((float)l);
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false).floatValue();
                    if (!includeUpper) {
                        u = FloatPoint.nextDown((float)u);
                    }
                }
                if (isSearchable && hasDocValues) {
                    Query query = FloatPoint.newRangeQuery((String)field, (float)l, (float)u);
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)NumericUtils.floatToSortableInt((float)l), (long)NumericUtils.floatToSortableInt((float)u));
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)NumericUtils.floatToSortableInt((float)l), (long)NumericUtils.floatToSortableInt((float)u));
                }
                return FloatPoint.newRangeQuery((String)field, (float)l, (float)u);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new FloatPoint(name, new float[]{value.floatValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, (long)NumericUtils.floatToSortableInt((float)value.floatValue())));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.floatValue()));
                }
                return fields;
            }

            @Override
            Number valueForSearch(String value) {
                return Float.valueOf(Float.parseFloat(value));
            }

            private void validateParsed(float value) {
                if (!Float.isFinite(value)) {
                    throw new IllegalArgumentException("[float] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        DOUBLE("double", IndexNumericFieldData.NumericType.DOUBLE){

            @Override
            public Double parse(Object value, boolean coerce) {
                double parsed = 3.objectToDouble(value);
                this.validateParsed(parsed);
                return parsed;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return DoublePoint.decodeDimension((byte[])value, (int)0);
            }

            @Override
            public Double parse(XContentParser parser, boolean coerce) throws IOException {
                double parsed = parser.doubleValue(coerce);
                this.validateParsed(parsed);
                return parsed;
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                double v = this.parse(value, false);
                if (isSearchable && hasDocValues) {
                    Query query = DoublePoint.newExactQuery((String)field, (double)v);
                    Query dvQuery = SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)NumericUtils.doubleToSortableLong((double)v));
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)NumericUtils.doubleToSortableLong((double)v));
                }
                return DoublePoint.newExactQuery((String)field, (double)v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocValues, boolean isSearchable) {
                double[] v = new double[values.size()];
                long[] points = new long[v.length];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i), false);
                    if (!hasDocValues) continue;
                    points[i] = NumericUtils.doubleToSortableLong((double)v[i]);
                }
                if (isSearchable && hasDocValues) {
                    return new IndexOrDocValuesQuery(DoublePoint.newSetQuery((String)field, (double[])v), SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])points));
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])points);
                }
                return DoublePoint.newSetQuery((String)field, (double[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                return 3.doubleRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> {
                    if (isSearchable && hasDocValues) {
                        Query query = DoublePoint.newRangeQuery((String)field, (double)l, (double)u);
                        Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)NumericUtils.doubleToSortableLong((double)l), (long)NumericUtils.doubleToSortableLong((double)u));
                        return new IndexOrDocValuesQuery(query, dvQuery);
                    }
                    if (hasDocValues) {
                        return SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)NumericUtils.doubleToSortableLong((double)l), (long)NumericUtils.doubleToSortableLong((double)u));
                    }
                    return DoublePoint.newRangeQuery((String)field, (double)l, (double)u);
                });
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new DoublePoint(name, new double[]{value.doubleValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, NumericUtils.doubleToSortableLong((double)value.doubleValue())));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.doubleValue()));
                }
                return fields;
            }

            @Override
            Number valueForSearch(String value) {
                return Double.parseDouble(value);
            }

            private void validateParsed(double value) {
                if (!Double.isFinite(value)) {
                    throw new IllegalArgumentException("[double] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        BYTE("byte", IndexNumericFieldData.NumericType.BYTE){

            @Override
            public Byte parse(Object value, boolean coerce) {
                double doubleValue = 4.objectToDouble(value);
                if (doubleValue < -128.0 || doubleValue > 127.0) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                return (byte)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return INTEGER.parsePoint(value).byteValue();
            }

            @Override
            public Short parse(XContentParser parser, boolean coerce) throws IOException {
                int value = parser.intValue(coerce);
                if (value < -128 || value > 127) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                }
                return (short)value;
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                return INTEGER.termQuery(field, value, hasDocValues, isSearchable);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocValues, boolean isSearchable) {
                return INTEGER.termsQuery(field, values, hasDocValues, isSearchable);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, hasDocValues, isSearchable, context);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                return INTEGER.createFields(name, value, indexed, docValued, stored);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.byteValue();
            }

            @Override
            Number valueForSearch(String value) {
                return Byte.parseByte(value);
            }
        }
        ,
        SHORT("short", IndexNumericFieldData.NumericType.SHORT){

            @Override
            public Short parse(Object value, boolean coerce) {
                double doubleValue = 5.objectToDouble(value);
                if (doubleValue < -32768.0 || doubleValue > 32767.0) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a short");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                return (short)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return INTEGER.parsePoint(value).shortValue();
            }

            @Override
            public Short parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.shortValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                return INTEGER.termQuery(field, value, hasDocValues, isSearchable);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocValues, boolean isSearchable) {
                return INTEGER.termsQuery(field, values, hasDocValues, isSearchable);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, hasDocValues, isSearchable, context);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                return INTEGER.createFields(name, value, indexed, docValued, stored);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.shortValue();
            }

            @Override
            Number valueForSearch(String value) {
                return Short.parseShort(value);
            }
        }
        ,
        INTEGER("integer", IndexNumericFieldData.NumericType.INT){

            @Override
            public Integer parse(Object value, boolean coerce) {
                double doubleValue = 6.objectToDouble(value);
                if (doubleValue < -2.147483648E9 || doubleValue > 2.147483647E9) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for an integer");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return (int)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return IntPoint.decodeDimension((byte[])value, (int)0);
            }

            @Override
            public Integer parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.intValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                if (6.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                int v = this.parse(value, true);
                if (isSearchable && hasDocValues) {
                    Query query = IntPoint.newExactQuery((String)field, (int)v);
                    Query dvQuery = SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)v);
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)v);
                }
                return IntPoint.newExactQuery((String)field, (int)v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocValues, boolean isSearchable) {
                int[] v = new int[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (6.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                long[] points = new long[v.length];
                if (hasDocValues) {
                    for (int i = 0; i < v.length; ++i) {
                        points[i] = v[i];
                    }
                }
                if (isSearchable && hasDocValues) {
                    return new IndexOrDocValuesQuery(IntPoint.newSetQuery((String)field, (int[])v), SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])points));
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])points);
                }
                return IntPoint.newSetQuery((String)field, (int[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                int l = Integer.MIN_VALUE;
                int u = Integer.MAX_VALUE;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, true);
                    boolean lowerTermHasDecimalPart = 6.hasDecimalPart(lowerTerm);
                    if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && 6.signum(lowerTerm) > 0.0) {
                        if (l == Integer.MAX_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        ++l;
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, true);
                    boolean upperTermHasDecimalPart = 6.hasDecimalPart(upperTerm);
                    if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && 6.signum(upperTerm) < 0.0) {
                        if (u == Integer.MIN_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        --u;
                    }
                }
                if (isSearchable && hasDocValues) {
                    Query query = IntPoint.newRangeQuery((String)field, (int)l, (int)u);
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)l, (long)u);
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                    if (context.indexSortedOnField(field)) {
                        query = new IndexSortSortedNumericDocValuesRangeQuery(field, (long)l, (long)u, query);
                    }
                    return query;
                }
                if (hasDocValues) {
                    Query query = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)l, (long)u);
                    if (context.indexSortedOnField(field)) {
                        query = new IndexSortSortedNumericDocValuesRangeQuery(field, (long)l, (long)u, query);
                    }
                    return query;
                }
                return IntPoint.newRangeQuery((String)field, (int)l, (int)u);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new IntPoint(name, new int[]{value.intValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, (long)value.intValue()));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.intValue()));
                }
                return fields;
            }

            @Override
            Number valueForSearch(String value) {
                return Integer.parseInt(value);
            }
        }
        ,
        LONG("long", IndexNumericFieldData.NumericType.LONG){

            @Override
            public Long parse(Object value, boolean coerce) {
                return 7.objectToLong(value, coerce);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return LongPoint.decodeDimension((byte[])value, (int)0);
            }

            @Override
            public Long parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.longValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                if (7.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                long v = this.parse(value, true);
                if (isSearchable && hasDocValues) {
                    Query query = LongPoint.newExactQuery((String)field, (long)v);
                    Query dvQuery = SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)v);
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)v);
                }
                return LongPoint.newExactQuery((String)field, (long)v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocValues, boolean isSearchable) {
                long[] v = new long[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (7.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                if (isSearchable && hasDocValues) {
                    return new IndexOrDocValuesQuery(LongPoint.newSetQuery((String)field, (long[])v), SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])v));
                }
                if (hasDocValues) {
                    return SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])v);
                }
                return LongPoint.newSetQuery((String)field, (long[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                return 7.longRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> {
                    if (isSearchable && hasDocValues) {
                        Query query = LongPoint.newRangeQuery((String)field, (long)l, (long)u);
                        Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)l, (long)u);
                        query = new IndexOrDocValuesQuery(query, dvQuery);
                        if (context.indexSortedOnField(field)) {
                            query = new IndexSortSortedNumericDocValuesRangeQuery(field, l.longValue(), u.longValue(), query);
                        }
                        return query;
                    }
                    if (hasDocValues) {
                        Query query = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)l, (long)u);
                        if (context.indexSortedOnField(field)) {
                            query = new IndexSortSortedNumericDocValuesRangeQuery(field, l.longValue(), u.longValue(), query);
                        }
                        return query;
                    }
                    return LongPoint.newRangeQuery((String)field, (long)l, (long)u);
                });
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new LongPoint(name, new long[]{value.longValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, value.longValue()));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.longValue()));
                }
                return fields;
            }

            @Override
            Number valueForSearch(String value) {
                return Long.parseLong(value);
            }
        }
        ,
        UNSIGNED_LONG("unsigned_long", IndexNumericFieldData.NumericType.UNSIGNED_LONG){

            @Override
            public BigInteger parse(Object value, boolean coerce) {
                return 8.objectToUnsignedLong(value, coerce);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return BigIntegerPoint.decodeDimension((byte[])value, (int)0);
            }

            @Override
            public BigInteger parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.bigIntegerValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value, boolean hasDocValues, boolean isSearchable) {
                if (8.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                BigInteger v = this.parse(value, true);
                if (isSearchable && hasDocValues) {
                    Query query = BigIntegerPoint.newExactQuery((String)field, (BigInteger)v);
                    Query dvQuery = SortedUnsignedLongDocValuesSetQuery.newSlowExactQuery(field, v);
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocValues) {
                    return SortedUnsignedLongDocValuesSetQuery.newSlowExactQuery(field, v);
                }
                return BigIntegerPoint.newExactQuery((String)field, (BigInteger)v);
            }

            @Override
            public Query termsQuery(String field, List<Object> values, boolean hasDocvalues, boolean isSearchable) {
                BigInteger[] v = new BigInteger[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (8.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                if (isSearchable && hasDocvalues) {
                    Query query = BigIntegerPoint.newSetQuery((String)field, (BigInteger[])v);
                    Query dvQuery = SortedUnsignedLongDocValuesSetQuery.newSlowSetQuery(field, v);
                    return new IndexOrDocValuesQuery(query, dvQuery);
                }
                if (hasDocvalues) {
                    return SortedUnsignedLongDocValuesSetQuery.newSlowSetQuery(field, v);
                }
                return BigIntegerPoint.newSetQuery((String)field, (BigInteger[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isSearchable, QueryShardContext context) {
                return 8.unsignedLongRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> {
                    if (isSearchable && hasDocValues) {
                        Query query = BigIntegerPoint.newRangeQuery((String)field, (BigInteger)l, (BigInteger)u);
                        Query dvQuery = SortedUnsignedLongDocValuesRangeQuery.newSlowRangeQuery(field, l, u);
                        return new IndexOrDocValuesQuery(query, dvQuery);
                    }
                    if (hasDocValues) {
                        return SortedUnsignedLongDocValuesRangeQuery.newSlowRangeQuery(field, l, u);
                    }
                    return BigIntegerPoint.newRangeQuery((String)field, (BigInteger)l, (BigInteger)u);
                });
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                BigInteger v = Numbers.toUnsignedLongExact((Number)value);
                if (indexed) {
                    fields.add((Field)new BigIntegerPoint(name, new BigInteger[]{v}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, v.longValue()));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, v.toString()));
                }
                return fields;
            }

            @Override
            Number valueForSearch(String value) {
                return new BigInteger(value);
            }
        };

        private final String name;
        private final IndexNumericFieldData.NumericType numericType;
        private final ParametrizedFieldMapper.TypeParser parser;

        private NumberType(String name, IndexNumericFieldData.NumericType numericType) {
            this.name = name;
            this.numericType = numericType;
            this.parser = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n, this, c.getSettings()));
        }

        public final String typeName() {
            return this.name;
        }

        public final IndexNumericFieldData.NumericType numericType() {
            return this.numericType;
        }

        public final ParametrizedFieldMapper.TypeParser parser() {
            return this.parser;
        }

        public abstract Query termQuery(String var1, Object var2, boolean var3, boolean var4);

        public abstract Query termsQuery(String var1, List<Object> var2, boolean var3, boolean var4);

        public abstract Query rangeQuery(String var1, Object var2, Object var3, boolean var4, boolean var5, boolean var6, boolean var7, QueryShardContext var8);

        public abstract Number parse(XContentParser var1, boolean var2) throws IOException;

        public abstract Number parse(Object var1, boolean var2);

        public abstract Number parsePoint(byte[] var1);

        public abstract List<Field> createFields(String var1, Number var2, boolean var3, boolean var4, boolean var5);

        abstract Number valueForSearch(String var1);

        Number valueForSearch(Number value) {
            return value;
        }

        public static boolean hasDecimalPart(Object number) {
            if (number instanceof Number) {
                double doubleValue = ((Number)number).doubleValue();
                return doubleValue % 1.0 != 0.0;
            }
            if (number instanceof BytesRef) {
                number = ((BytesRef)number).utf8ToString();
            }
            if (number instanceof String) {
                return Double.parseDouble((String)number) % 1.0 != 0.0;
            }
            return false;
        }

        static double signum(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                return Math.signum(doubleValue);
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Math.signum(Double.parseDouble(value.toString()));
        }

        public static double objectToDouble(Object value) {
            double doubleValue = value instanceof Number ? ((Number)value).doubleValue() : (value instanceof BytesRef ? Double.parseDouble(((BytesRef)value).utf8ToString()) : Double.parseDouble(value.toString()));
            return doubleValue;
        }

        public static long objectToLong(Object value, boolean coerce) {
            if (value instanceof Long) {
                return (Long)value;
            }
            double doubleValue = NumberType.objectToDouble(value);
            if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                throw new IllegalArgumentException("Value [" + value + "] is out of range for a long");
            }
            if (!coerce && doubleValue % 1.0 != 0.0) {
                throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
            }
            String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            return Numbers.toLong((String)stringValue, (boolean)coerce);
        }

        public static BigInteger objectToUnsignedLong(Object value, boolean coerce) {
            if (value instanceof Long) {
                return Numbers.toUnsignedBigInteger((long)((Long)value));
            }
            double doubleValue = NumberType.objectToDouble(value);
            if (doubleValue < Numbers.MIN_UNSIGNED_LONG_VALUE.doubleValue() || doubleValue > Numbers.MAX_UNSIGNED_LONG_VALUE.doubleValue()) {
                throw new IllegalArgumentException("Value [" + value + "] is out of range for an unsigned long");
            }
            if (!coerce && doubleValue % 1.0 != 0.0) {
                throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
            }
            String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            return Numbers.toUnsignedLong((String)stringValue, (boolean)coerce);
        }

        public static Query doubleRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<Double, Double, Query> builder) {
            double l = Double.NEGATIVE_INFINITY;
            double u = Double.POSITIVE_INFINITY;
            if (lowerTerm != null) {
                l = NumberType.objectToDouble(lowerTerm);
                if (!includeLower) {
                    l = DoublePoint.nextUp((double)l);
                }
            }
            if (upperTerm != null) {
                u = NumberType.objectToDouble(upperTerm);
                if (!includeUpper) {
                    u = DoublePoint.nextDown((double)u);
                }
            }
            return builder.apply(l, u);
        }

        public static Query longRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<Long, Long, Query> builder) {
            long l = Long.MIN_VALUE;
            long u = Long.MAX_VALUE;
            if (lowerTerm != null) {
                l = NumberType.objectToLong(lowerTerm, true);
                boolean lowerTermHasDecimalPart = NumberType.hasDecimalPart(lowerTerm);
                if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && NumberType.signum(lowerTerm) > 0.0) {
                    if (l == Long.MAX_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    ++l;
                }
            }
            if (upperTerm != null) {
                u = NumberType.objectToLong(upperTerm, true);
                boolean upperTermHasDecimalPart = NumberType.hasDecimalPart(upperTerm);
                if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && NumberType.signum(upperTerm) < 0.0) {
                    if (u == Long.MIN_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    --u;
                }
            }
            return builder.apply(l, u);
        }

        public static Query unsignedLongRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<BigInteger, BigInteger, Query> builder) {
            BigInteger l = Numbers.MIN_UNSIGNED_LONG_VALUE;
            BigInteger u = Numbers.MAX_UNSIGNED_LONG_VALUE;
            if (lowerTerm != null) {
                l = NumberType.objectToUnsignedLong(lowerTerm, true);
                boolean lowerTermHasDecimalPart = NumberType.hasDecimalPart(lowerTerm);
                if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && NumberType.signum(lowerTerm) > 0.0) {
                    if (l.compareTo(Numbers.MAX_UNSIGNED_LONG_VALUE) == 0) {
                        return new MatchNoDocsQuery();
                    }
                    l = l.add(BigInteger.ONE);
                }
            }
            if (upperTerm != null) {
                u = NumberType.objectToUnsignedLong(upperTerm, true);
                boolean upperTermHasDecimalPart = NumberType.hasDecimalPart(upperTerm);
                if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && NumberType.signum(upperTerm) < 0.0) {
                    if (u.compareTo(Numbers.MAX_UNSIGNED_LONG_VALUE) == 0) {
                        return new MatchNoDocsQuery();
                    }
                    u = u.subtract(BigInteger.ONE);
                }
            }
            return builder.apply(l, u);
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> indexed = ParametrizedFieldMapper.Parameter.indexParam(m -> NumberFieldMapper.toType((FieldMapper)m).indexed, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> NumberFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m -> NumberFieldMapper.toType((FieldMapper)m).stored, false);
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> coerce;
        private final ParametrizedFieldMapper.Parameter<Number> nullValue;
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        private final NumberType type;

        public Builder(String name, NumberType type, Settings settings) {
            this(name, type, FieldMapper.IGNORE_MALFORMED_SETTING.get(settings), COERCE_SETTING.get(settings));
        }

        public static Builder docValuesOnly(String name, NumberType type) {
            Builder builder = new Builder(name, type, false, false);
            builder.indexed.setValue(false);
            return builder;
        }

        public Builder(String name, NumberType type, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            this.type = type;
            this.ignoreMalformed = ParametrizedFieldMapper.Parameter.explicitBoolParam("ignore_malformed", true, m -> NumberFieldMapper.toType((FieldMapper)m).ignoreMalformed, ignoreMalformedByDefault);
            this.coerce = ParametrizedFieldMapper.Parameter.explicitBoolParam("coerce", true, m -> NumberFieldMapper.toType((FieldMapper)m).coerce, coerceByDefault);
            this.nullValue = new ParametrizedFieldMapper.Parameter<Number>("null_value", false, () -> null, (n, c, o) -> o == null ? (Number)null : (Number)type.parse(o, false), m -> NumberFieldMapper.toType((FieldMapper)m).nullValue).acceptsNull();
        }

        Builder nullValue(Number number) {
            this.nullValue.setValue(number);
            return this;
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.coerce, this.nullValue, this.meta);
        }

        @Override
        public NumberFieldMapper build(Mapper.BuilderContext context) {
            NumberFieldType ft = new NumberFieldType(this.buildFullName(context), this);
            return new NumberFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }
}

