/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.rest;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionModule;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.extensions.DiscoveryExtensionNode;
import org.opensearch.extensions.rest.ExtensionRestRequest;
import org.opensearch.extensions.rest.RegisterRestActionsRequest;
import org.opensearch.extensions.rest.RestExecuteOnExtensionResponse;
import org.opensearch.http.HttpRequest;
import org.opensearch.identity.IdentityService;
import org.opensearch.identity.Subject;
import org.opensearch.identity.tokens.OnBehalfOfClaims;
import org.opensearch.identity.tokens.TokenManager;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.NamedRoute;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class RestSendToExtensionAction
extends BaseRestHandler {
    private static final String SEND_TO_EXTENSION_ACTION = "send_to_extension_action";
    private static final Logger logger = LogManager.getLogger(RestSendToExtensionAction.class);
    private final List<RestHandler.Route> routes;
    private final List<RestHandler.DeprecatedRoute> deprecatedRoutes;
    private final String pathPrefix;
    private final DiscoveryExtensionNode discoveryExtensionNode;
    private final TransportService transportService;
    private final IdentityService identityService;
    private static final Set<String> allowList = Set.of("Content-Type");
    private static final Set<String> denyList = Set.of("Authorization", "Proxy-Authorization");

    public RestSendToExtensionAction(RegisterRestActionsRequest restActionsRequest, DiscoveryExtensionNode discoveryExtensionNode, TransportService transportService, ActionModule.DynamicActionRegistry dynamicActionRegistry, IdentityService identityService) {
        String path;
        RestRequest.Method method;
        this.pathPrefix = "/_extensions/_" + restActionsRequest.getUniqueId();
        ArrayList<NamedRoute> restActionsAsRoutes = new ArrayList<NamedRoute>();
        for (String restAction : restActionsRequest.getRestActions()) {
            String name;
            HashSet<String> actionNames = new HashSet<String>();
            String[] parts = restAction.split(" ");
            if (parts.length < 3) {
                throw new IllegalArgumentException("REST action must contain at least a REST method, a route and a unique name");
            }
            try {
                method = RestRequest.Method.valueOf(parts[0].trim());
                path = this.pathPrefix + parts[1].trim();
                name = parts[2].trim();
                if (parts.length > 3) {
                    String[] actions;
                    for (String action : actions = parts[3].split(",")) {
                        String trimmed = action.trim();
                        if (trimmed.isEmpty()) continue;
                        actionNames.add(trimmed);
                    }
                }
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                throw new IllegalArgumentException(restAction + " does not begin with a valid REST method");
            }
            logger.info("Registering: " + method + " " + path + " " + name);
            NamedRoute nr = new NamedRoute.Builder().method(method).path(path).uniqueName(name).legacyActionNames(actionNames).build();
            restActionsAsRoutes.add(nr);
            dynamicActionRegistry.registerDynamicRoute(nr, this);
        }
        this.routes = Collections.unmodifiableList(restActionsAsRoutes);
        ArrayList<RestHandler.DeprecatedRoute> restActionsAsDeprecatedRoutes = new ArrayList<RestHandler.DeprecatedRoute>();
        List<String> deprecatedActions = restActionsRequest.getDeprecatedRestActions();
        for (int i = 0; i < deprecatedActions.size() - 1; i += 2) {
            String restAction = deprecatedActions.get(i);
            String message = deprecatedActions.get(i + 1);
            int delim = restAction.indexOf(32);
            try {
                method = RestRequest.Method.valueOf(restAction.substring(0, delim));
                path = this.pathPrefix + restAction.substring(delim).trim();
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                throw new IllegalArgumentException(restAction + " does not begin with a valid REST method");
            }
            logger.info("Registering: " + method + " " + path + " with deprecation message " + message);
            restActionsAsDeprecatedRoutes.add(new RestHandler.DeprecatedRoute(method, path, message));
        }
        this.deprecatedRoutes = Collections.unmodifiableList(restActionsAsDeprecatedRoutes);
        this.discoveryExtensionNode = discoveryExtensionNode;
        this.transportService = transportService;
        this.identityService = identityService;
    }

    @Override
    public String getName() {
        return this.discoveryExtensionNode.getId() + ":send_to_extension_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return this.routes;
    }

    @Override
    public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return this.deprecatedRoutes;
    }

    public Map<String, List<String>> filterHeaders(Map<String, List<String>> headers, Set<String> allowList, Set<String> denyList) {
        Map<String, List<String>> filteredHeaders = headers.entrySet().stream().filter(e -> !denyList.contains(e.getKey())).filter(e -> allowList.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return filteredHeaders;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        HttpRequest httpRequest = request.getHttpRequest();
        String path = request.path();
        RestRequest.Method method = request.method();
        String uri = httpRequest.uri();
        Map<String, String> params = request.params();
        Map<String, List<String>> headers = request.getHeaders();
        MediaType contentType = request.getMediaType();
        BytesReference content = request.content();
        HttpRequest.HttpVersion httpVersion = httpRequest.protocolVersion();
        if (path.startsWith(this.pathPrefix)) {
            path = path.substring(this.pathPrefix.length());
        }
        String message = "Forwarding the request " + method + " " + path + " to " + this.discoveryExtensionNode;
        logger.info(message);
        final RestExecuteOnExtensionResponse restExecuteOnExtensionResponse = new RestExecuteOnExtensionResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", message.getBytes(StandardCharsets.UTF_8), Collections.emptyMap(), Collections.emptyList(), false);
        final CompletableFuture inProgressFuture = new CompletableFuture();
        TransportResponseHandler<RestExecuteOnExtensionResponse> restExecuteOnExtensionResponseHandler = new TransportResponseHandler<RestExecuteOnExtensionResponse>(){

            public RestExecuteOnExtensionResponse read(StreamInput in) throws IOException {
                return new RestExecuteOnExtensionResponse(in);
            }

            @Override
            public void handleResponse(RestExecuteOnExtensionResponse response) {
                logger.info("Received response from extension: {}", (Object)response.getStatus());
                restExecuteOnExtensionResponse.setStatus(response.getStatus());
                restExecuteOnExtensionResponse.setContentType(response.getContentType());
                restExecuteOnExtensionResponse.setContent(response.getContent());
                restExecuteOnExtensionResponse.setHeaders(response.getHeaders());
                response.getConsumedParams().stream().forEach(p -> request.param((String)p));
                if (response.isContentConsumed()) {
                    request.content();
                }
                inProgressFuture.complete(response);
            }

            @Override
            public void handleException(TransportException exp) {
                logger.debug("REST request failed", (Throwable)((Object)exp));
                request.params().keySet().stream().forEach(p -> request.param((String)p));
                request.content();
                inProgressFuture.completeExceptionally((Throwable)((Object)exp));
            }

            @Override
            public String executor() {
                return "generic";
            }
        };
        try {
            Map<String, List<String>> filteredHeaders = this.filterHeaders(headers, allowList, denyList);
            TokenManager tokenManager = this.identityService.getTokenManager();
            Subject subject = this.identityService.getSubject();
            OnBehalfOfClaims claims = new OnBehalfOfClaims(this.discoveryExtensionNode.getId(), subject.getPrincipal().getName());
            this.transportService.sendRequest(this.discoveryExtensionNode, "internal:extensions/restexecuteonextensiontaction", new ExtensionRestRequest(method, uri, path, params, filteredHeaders, contentType, content, tokenManager.issueOnBehalfOfToken(subject, claims).asAuthHeaderValue(), httpVersion), restExecuteOnExtensionResponseHandler);
            inProgressFuture.orTimeout(10L, TimeUnit.SECONDS).join();
        }
        catch (CompletionException e2) {
            Throwable cause = e2.getCause();
            if (cause instanceof TimeoutException) {
                return channel -> channel.sendResponse(new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, "No response from extension to request."));
            }
            if (e2.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e2.getCause();
            }
            if (e2.getCause() instanceof Error) {
                throw (Error)e2.getCause();
            }
            throw new RuntimeException(e2.getCause());
        }
        catch (Exception ex) {
            logger.info("Failed to send REST Actions to extension " + this.discoveryExtensionNode.getName(), (Throwable)ex);
            return channel -> channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, ex.getMessage()));
        }
        BytesRestResponse restResponse = new BytesRestResponse(restExecuteOnExtensionResponse.getStatus(), restExecuteOnExtensionResponse.getContentType(), restExecuteOnExtensionResponse.getContent());
        restExecuteOnExtensionResponse.getHeaders().entrySet().stream().forEach(e -> ((List)e.getValue()).stream().forEach(v -> restResponse.addHeader((String)e.getKey(), (String)v)));
        return channel -> channel.sendResponse(restResponse);
    }
}

