/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public class FeatureFlags {
    public static final String SEARCHABLE_SNAPSHOT_EXTENDED_COMPATIBILITY = "opensearch.experimental.feature.searchable_snapshot.extended_compatibility.enabled";
    public static final String EXTENSIONS = "opensearch.experimental.feature.extensions.enabled";
    public static final String IDENTITY = "opensearch.experimental.feature.identity.enabled";
    public static final String TELEMETRY = "opensearch.experimental.feature.telemetry.enabled";
    public static final String DATETIME_FORMATTER_CACHING = "opensearch.experimental.optimization.datetime_formatter_caching.enabled";
    public static final String WRITEABLE_REMOTE_INDEX = "opensearch.experimental.feature.writeable_remote_index.enabled";
    public static final String DOC_ID_FUZZY_SET = "opensearch.experimental.optimize_doc_id_lookup.fuzzy_set.enabled";
    private static Settings settings;
    public static final Setting<Boolean> EXTENSIONS_SETTING;
    public static final Setting<Boolean> IDENTITY_SETTING;
    public static final Setting<Boolean> TELEMETRY_SETTING;
    public static final Setting<Boolean> DATETIME_FORMATTER_CACHING_SETTING;
    public static final Setting<Boolean> WRITEABLE_REMOTE_INDEX_SETTING;
    public static final Setting<Boolean> DOC_ID_FUZZY_SET_SETTING;

    public static void initializeFeatureFlags(Settings openSearchSettings) {
        settings = openSearchSettings;
    }

    public static boolean isEnabled(String featureFlagName) {
        if ("true".equalsIgnoreCase(System.getProperty(featureFlagName))) {
            return true;
        }
        return settings != null && settings.getAsBoolean(featureFlagName, false) != false;
    }

    public static boolean isEnabled(Setting<Boolean> featureFlag) {
        if ("true".equalsIgnoreCase(System.getProperty(featureFlag.getKey()))) {
            return true;
        }
        if (settings != null) {
            return featureFlag.get(settings);
        }
        return featureFlag.getDefault(Settings.EMPTY);
    }

    static {
        EXTENSIONS_SETTING = Setting.boolSetting(EXTENSIONS, false, Setting.Property.NodeScope);
        IDENTITY_SETTING = Setting.boolSetting(IDENTITY, false, Setting.Property.NodeScope);
        TELEMETRY_SETTING = Setting.boolSetting(TELEMETRY, false, Setting.Property.NodeScope);
        DATETIME_FORMATTER_CACHING_SETTING = Setting.boolSetting(DATETIME_FORMATTER_CACHING, true, Setting.Property.NodeScope);
        WRITEABLE_REMOTE_INDEX_SETTING = Setting.boolSetting(WRITEABLE_REMOTE_INDEX, false, Setting.Property.NodeScope);
        DOC_ID_FUZZY_SET_SETTING = Setting.boolSetting(DOC_ID_FUZZY_SET, false, Setting.Property.NodeScope);
    }
}

