/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.cache.store.builders;

import java.util.function.ToLongBiFunction;
import org.opensearch.common.cache.store.StoreAwareCache;
import org.opensearch.common.cache.store.listeners.StoreAwareCacheEventListener;
import org.opensearch.common.unit.TimeValue;

public abstract class StoreAwareCacheBuilder<K, V> {
    private long maxWeightInBytes;
    private ToLongBiFunction<K, V> weigher;
    private TimeValue expireAfterAcess;
    private StoreAwareCacheEventListener<K, V> eventListener;

    public StoreAwareCacheBuilder<K, V> setMaximumWeightInBytes(long sizeInBytes) {
        this.maxWeightInBytes = sizeInBytes;
        return this;
    }

    public StoreAwareCacheBuilder<K, V> setWeigher(ToLongBiFunction<K, V> weigher) {
        this.weigher = weigher;
        return this;
    }

    public StoreAwareCacheBuilder<K, V> setExpireAfterAccess(TimeValue expireAfterAcess) {
        this.expireAfterAcess = expireAfterAcess;
        return this;
    }

    public StoreAwareCacheBuilder<K, V> setEventListener(StoreAwareCacheEventListener<K, V> eventListener) {
        this.eventListener = eventListener;
        return this;
    }

    public long getMaxWeightInBytes() {
        return this.maxWeightInBytes;
    }

    public TimeValue getExpireAfterAcess() {
        return this.expireAfterAcess;
    }

    public ToLongBiFunction<K, V> getWeigher() {
        return this.weigher;
    }

    public StoreAwareCacheEventListener<K, V> getEventListener() {
        return this.eventListener;
    }

    public abstract StoreAwareCache<K, V> build();
}

