/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.coordination.CoordinationMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public class Reconfigurator {
    private static final Logger logger = LogManager.getLogger(Reconfigurator.class);
    public static final Setting<Boolean> CLUSTER_AUTO_SHRINK_VOTING_CONFIGURATION = Setting.boolSetting("cluster.auto_shrink_voting_configuration", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private volatile boolean autoShrinkVotingConfiguration;

    public Reconfigurator(Settings settings, ClusterSettings clusterSettings) {
        this.autoShrinkVotingConfiguration = CLUSTER_AUTO_SHRINK_VOTING_CONFIGURATION.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_AUTO_SHRINK_VOTING_CONFIGURATION, this::setAutoShrinkVotingConfiguration);
    }

    public void setAutoShrinkVotingConfiguration(boolean autoShrinkVotingConfiguration) {
        this.autoShrinkVotingConfiguration = autoShrinkVotingConfiguration;
    }

    private static int roundDownToOdd(int size) {
        return size - (size % 2 == 0 ? 1 : 0);
    }

    public String toString() {
        return "Reconfigurator{autoShrinkVotingConfiguration=" + this.autoShrinkVotingConfiguration + "}";
    }

    public CoordinationMetadata.VotingConfiguration reconfigure(Set<DiscoveryNode> liveNodes, Set<String> retiredNodeIds, DiscoveryNode currentClusterManager, CoordinationMetadata.VotingConfiguration currentConfig) {
        assert (liveNodes.contains(currentClusterManager)) : "liveNodes = " + liveNodes + " cluster-manager = " + currentClusterManager;
        logger.trace("{} reconfiguring {} based on liveNodes={}, retiredNodeIds={}, currentClusterManager={}", (Object)this, (Object)currentConfig, liveNodes, retiredNodeIds, (Object)currentClusterManager);
        Set<String> liveNodeIds = liveNodes.stream().filter(DiscoveryNode::isClusterManagerNode).map(DiscoveryNode::getId).collect(Collectors.toSet());
        Set<String> currentConfigNodeIds = currentConfig.getNodeIds();
        TreeSet orderedCandidateNodes = new TreeSet();
        liveNodes.stream().filter(DiscoveryNode::isClusterManagerNode).filter(n -> !retiredNodeIds.contains(n.getId())).forEach(n -> orderedCandidateNodes.add(new VotingConfigNode(n.getId(), true, n.getId().equals(currentClusterManager.getId()), currentConfigNodeIds.contains(n.getId()))));
        currentConfigNodeIds.stream().filter(nid -> !liveNodeIds.contains(nid)).filter(nid -> !retiredNodeIds.contains(nid)).forEach(nid -> orderedCandidateNodes.add(new VotingConfigNode((String)nid, false, false, true)));
        int nonRetiredConfigSize = Math.toIntExact(orderedCandidateNodes.stream().filter(n -> n.inCurrentConfig).count());
        int minimumConfigEnforcedSize = this.autoShrinkVotingConfiguration ? (nonRetiredConfigSize < 3 ? 1 : 3) : nonRetiredConfigSize;
        int nonRetiredLiveNodeCount = Math.toIntExact(orderedCandidateNodes.stream().filter(n -> n.live).count());
        int targetSize = Math.max(Reconfigurator.roundDownToOdd(nonRetiredLiveNodeCount), minimumConfigEnforcedSize);
        CoordinationMetadata.VotingConfiguration newConfig = new CoordinationMetadata.VotingConfiguration(orderedCandidateNodes.stream().limit(targetSize).map(n -> n.id).collect(Collectors.toSet()));
        if (newConfig.hasQuorum(liveNodeIds)) {
            return newConfig;
        }
        return currentConfig;
    }

    static class VotingConfigNode
    implements Comparable<VotingConfigNode> {
        final String id;
        final boolean live;
        final boolean currentClusterManager;
        final boolean inCurrentConfig;

        VotingConfigNode(String id, boolean live, boolean currentClusterManager, boolean inCurrentConfig) {
            this.id = id;
            this.live = live;
            this.currentClusterManager = currentClusterManager;
            this.inCurrentConfig = inCurrentConfig;
        }

        @Override
        public int compareTo(VotingConfigNode other) {
            int currentClusterManagerComp = Boolean.compare(other.currentClusterManager, this.currentClusterManager);
            if (currentClusterManagerComp != 0) {
                return currentClusterManagerComp;
            }
            int liveComp = Boolean.compare(other.live, this.live);
            if (liveComp != 0) {
                return liveComp;
            }
            int inCurrentConfigComp = Boolean.compare(other.inCurrentConfig, this.inCurrentConfig);
            if (inCurrentConfigComp != 0) {
                return inCurrentConfigComp;
            }
            return this.id.compareTo(other.id);
        }

        public String toString() {
            return "VotingConfigNode{id='" + this.id + "', live=" + this.live + ", currentClusterManager=" + this.currentClusterManager + ", inCurrentConfig=" + this.inCurrentConfig + "}";
        }
    }
}

