/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

@PublicApi(since="1.0.0")
public abstract class RetryableAction<Response> {
    private final Logger logger;
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private final ThreadPool threadPool;
    private final long initialDelayMillis;
    private final long timeoutMillis;
    private final long startMillis;
    private final ActionListener<Response> finalListener;
    private final String executor;
    private final BackoffPolicy backoffPolicy;
    private volatile Scheduler.ScheduledCancellable retryTask;

    public RetryableAction(Logger logger, ThreadPool threadPool, TimeValue initialDelay, TimeValue timeoutValue, ActionListener<Response> listener) {
        this(logger, threadPool, initialDelay, timeoutValue, listener, BackoffPolicy.exponentialFullJitterBackoff(initialDelay.getMillis()), "same");
    }

    public RetryableAction(Logger logger, ThreadPool threadPool, TimeValue initialDelay, TimeValue timeoutValue, ActionListener<Response> listener, BackoffPolicy backoffPolicy, String executor) {
        this.logger = logger;
        this.threadPool = threadPool;
        this.initialDelayMillis = initialDelay.getMillis();
        if (this.initialDelayMillis < 1L) {
            throw new IllegalArgumentException("Initial delay was less than 1 millisecond: " + initialDelay);
        }
        this.timeoutMillis = timeoutValue.getMillis();
        this.startMillis = threadPool.relativeTimeInMillis();
        this.finalListener = listener;
        this.executor = executor;
        this.backoffPolicy = backoffPolicy;
    }

    public void run() {
        RetryingListener retryingListener = new RetryingListener(this.backoffPolicy.iterator(), null);
        Runnable runnable = this.createRunnable(retryingListener);
        this.threadPool.executor(this.executor).execute(runnable);
    }

    public void cancel(Exception e) {
        if (this.isDone.compareAndSet(false, true)) {
            Scheduler.ScheduledCancellable localRetryTask = this.retryTask;
            if (localRetryTask != null) {
                localRetryTask.cancel();
            }
            this.onFinished();
            this.finalListener.onFailure(e);
        }
    }

    private Runnable createRunnable(RetryingListener retryingListener) {
        return new ActionRunnable<Response>(retryingListener){

            @Override
            protected void doRun() {
                RetryableAction.this.retryTask = null;
                if (!RetryableAction.this.isDone.get()) {
                    RetryableAction.this.tryAction(this.listener);
                }
            }

            @Override
            public void onRejection(Exception e) {
                RetryableAction.this.retryTask = null;
                this.onFailure(e);
            }
        };
    }

    public abstract void tryAction(ActionListener<Response> var1);

    public abstract boolean shouldRetry(Exception var1);

    public void onFinished() {
    }

    public Exception getTimeoutException(Exception e) {
        return e;
    }

    private class RetryingListener
    implements ActionListener<Response> {
        private static final int MAX_EXCEPTIONS = 4;
        private ArrayDeque<Exception> caughtExceptions;
        private Iterator<TimeValue> backoffDelayIterator;

        private RetryingListener(Iterator<TimeValue> backoffDelayIterator, ArrayDeque<Exception> caughtExceptions) {
            this.caughtExceptions = caughtExceptions;
            this.backoffDelayIterator = backoffDelayIterator;
        }

        public void onResponse(Response response) {
            if (RetryableAction.this.isDone.compareAndSet(false, true)) {
                RetryableAction.this.onFinished();
                RetryableAction.this.finalListener.onResponse(response);
            }
        }

        public void onFailure(Exception e) {
            if (RetryableAction.this.shouldRetry(e)) {
                long elapsedMillis = RetryableAction.this.threadPool.relativeTimeInMillis() - RetryableAction.this.startMillis;
                if (elapsedMillis >= RetryableAction.this.timeoutMillis) {
                    RetryableAction.this.logger.debug(() -> new ParameterizedMessage("retryable action timed out after {}", (Object)TimeValue.timeValueMillis((long)elapsedMillis)), (Throwable)e);
                    this.onFinalFailure(RetryableAction.this.getTimeoutException(e));
                } else {
                    this.addException(e);
                    TimeValue delay = this.backoffDelayIterator.next();
                    Runnable runnable = RetryableAction.this.createRunnable(this);
                    if (!RetryableAction.this.isDone.get()) {
                        RetryableAction.this.logger.debug(() -> new ParameterizedMessage("retrying action that failed in {}", (Object)delay), (Throwable)e);
                        try {
                            RetryableAction.this.retryTask = RetryableAction.this.threadPool.schedule(runnable, delay, RetryableAction.this.executor);
                        }
                        catch (OpenSearchRejectedExecutionException ree) {
                            this.onFinalFailure((Exception)((Object)ree));
                        }
                    }
                }
            } else {
                this.onFinalFailure(e);
            }
        }

        private void onFinalFailure(Exception e) {
            this.addException(e);
            if (RetryableAction.this.isDone.compareAndSet(false, true)) {
                RetryableAction.this.onFinished();
                RetryableAction.this.finalListener.onFailure(this.buildFinalException());
            }
        }

        private Exception buildFinalException() {
            Exception suppressed;
            Exception topLevel = this.caughtExceptions.removeFirst();
            while ((suppressed = this.caughtExceptions.pollFirst()) != null) {
                topLevel.addSuppressed(suppressed);
            }
            return topLevel;
        }

        private void addException(Exception e) {
            if (this.caughtExceptions != null) {
                if (this.caughtExceptions.size() == 4) {
                    this.caughtExceptions.removeLast();
                }
            } else {
                this.caughtExceptions = new ArrayDeque(4);
            }
            this.caughtExceptions.addFirst(e);
        }
    }
}

