/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.Collection;
import org.opensearch.action.search.SearchQueryCounters;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.telemetry.metrics.tags.Tags;

public class SearchQueryAggregationCategorizer {
    private static final String TYPE_TAG = "type";
    private final SearchQueryCounters searchQueryCounters;

    public SearchQueryAggregationCategorizer(SearchQueryCounters searchQueryCounters) {
        this.searchQueryCounters = searchQueryCounters;
    }

    public void incrementSearchQueryAggregationCounters(Collection<AggregationBuilder> aggregatorFactories) {
        for (AggregationBuilder aggregationBuilder : aggregatorFactories) {
            this.incrementCountersRecursively(aggregationBuilder);
        }
    }

    private void incrementCountersRecursively(AggregationBuilder aggregationBuilder) {
        String aggregationType = aggregationBuilder.getType();
        this.searchQueryCounters.aggCounter.add(1.0, Tags.create().addTag(TYPE_TAG, aggregationType));
        Collection<AggregationBuilder> subAggregations = aggregationBuilder.getSubAggregations();
        if (subAggregations != null && !subAggregations.isEmpty()) {
            for (AggregationBuilder subAggregation : subAggregations) {
                this.incrementCountersRecursively(subAggregation);
            }
        }
        Collection<PipelineAggregationBuilder> pipelineAggregations = aggregationBuilder.getPipelineAggregations();
        for (PipelineAggregationBuilder pipelineAggregation : pipelineAggregations) {
            String pipelineAggregationType = pipelineAggregation.getType();
            this.searchQueryCounters.aggCounter.add(1.0, Tags.create().addTag(TYPE_TAG, pipelineAggregationType));
        }
    }
}

