/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.tasks.resourcetracker;

import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.tasks.resourcetracker.ResourceStatsType;
import org.opensearch.core.tasks.resourcetracker.ResourceUsageInfo;
import org.opensearch.core.tasks.resourcetracker.ResourceUsageMetric;

@PublicApi(since="2.1.0")
public class ThreadResourceInfo {
    private final long threadId;
    private volatile boolean isActive = true;
    private final ResourceStatsType statsType;
    private final ResourceUsageInfo resourceUsageInfo;

    public ThreadResourceInfo(long threadId, ResourceStatsType statsType, ResourceUsageMetric ... resourceUsageMetrics) {
        this.threadId = threadId;
        this.statsType = statsType;
        this.resourceUsageInfo = new ResourceUsageInfo(resourceUsageMetrics);
    }

    public void recordResourceUsageMetrics(ResourceUsageMetric ... resourceUsageMetrics) {
        this.resourceUsageInfo.recordResourceUsageMetrics(resourceUsageMetrics);
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public ResourceStatsType getStatsType() {
        return this.statsType;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public ResourceUsageInfo getResourceUsageInfo() {
        return this.resourceUsageInfo;
    }

    public String toString() {
        return this.resourceUsageInfo + ", stats_type=" + this.statsType + ", is_active=" + this.isActive + ", threadId=" + this.threadId;
    }
}

